/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.bean.LoadApplyEntity;
import com.ejianc.business.jlcost.finance.service.IBackService;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.business.jlcost.finance.vo.LoadApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"loadApply"})
public class LoadApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-Smwe6l0001";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String BILL_CODE = "LoadApply";
    @Autowired
    private ILoadApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBackService backService;
    @Autowired
    private IReimburseService reimburseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadApplyVO> saveOrUpdate(@RequestBody LoadApplyVO saveOrUpdateVO) {
        LoadApplyEntity entity;
        if (saveOrUpdateVO.getBackedMny() == null) {
            saveOrUpdateVO.setBackedMny(BigDecimal.valueOf(0L));
        }
        if (saveOrUpdateVO.getCumulativeMny() == null) {
            saveOrUpdateVO.setCumulativeMny(BigDecimal.valueOf(0L));
        }
        if (saveOrUpdateVO.getStatus() == null) {
            saveOrUpdateVO.setStatus(Integer.valueOf(1));
        }
        if ((entity = (LoadApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LoadApplyEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LoadApplyVO vo = (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LoadApplyVO> queryDetail(Long id) {
        LoadApplyEntity entity = (LoadApplyEntity)((Object)this.service.selectById(id));
        BigDecimal backedMny = this.backService.addBackMny(entity.getId());
        entity.setBackedMny(backedMny);
        LoadApplyVO vo = (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LoadApplyVO loadApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        }
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List loadApplyVOS = BeanMapper.mapList((Iterable)records, LoadApplyVO.class);
        pageData.setRecords(loadApplyVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        }
        List list = this.service.queryList(param);
        List applyVOList = BeanMapper.mapList((Iterable)list, LoadApplyVO.class);
        for (LoadApplyVO vo : applyVOList) {
            if (vo.getStatus() == 1) {
                vo.setLoanStatus("\u7533\u8bf7\u4e2d");
            }
            if (vo.getStatus() == 2) {
                vo.setLoanStatus("\u4f7f\u7528\u4e2d");
            }
            if (vo.getStatus() == 3) {
                vo.setLoanStatus("\u5df2\u7ed3\u675f");
            }
            if (vo.getBillState() == 0) {
                vo.setBillStateName("\u81ea\u7531\u6001");
            }
            if (vo.getBillState() == 1) {
                vo.setBillStateName("\u5df2\u63d0\u4ea4");
            }
            if (vo.getBillState() == 2 || vo.getBillState() == 5) {
                vo.setBillStateName("\u5ba1\u6279\u4e2d");
            }
            if (vo.getBillState() == 3) {
                vo.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
            }
            if (vo.getBillState() != 4) continue;
            vo.setBillStateName("\u5ba1\u6279\u9a73\u56de");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", applyVOList);
        ExcelExport.getInstance().export("LoadApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLoadApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> refLoadApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)employeeId));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("billState", new Parameter("in", list));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LoadApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

