package com.ejianc.business.jlcost.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlcost.finance.bean.InvoiceDetailEntity;

/**
 * 资金管理-开票登记
 *
 * @author generator
 */
@TableName("ejc_finance_invoice")
public class InvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "contract_id")
    private Long contractId; // 合同ID
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode; // 合同编码
    @TableField(value = "project_id")
    private Long projectId; // 项目Id
    @TableField(value = "project_code")
    private String projectCode; // 项目code
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; //组织ID
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "org_code")
    private String orgCode; // 组织code
    @TableField(value = "parent_org_id")
    private Long parentOrgId; //父级组织ID
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织code
    @TableField(value = "customer_id")
    private Long customerId; // 合同甲方Id
    @TableField(value = "customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 合同乙方Id
    @TableField(value = "supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value = "invoice_date")
    private Date invoiceDate; // 登记日期
    @TableField(value = "invoice_mny")
    private BigDecimal invoiceMny; // 发票金额（无税）
    @TableField(value = "invoice_tax")
    private BigDecimal invoiceTax; // 发票税额
    @TableField(value = "invoice_tax_mny")
    private BigDecimal invoiceTaxMny; // 发票金额
    @TableField(value = "cumulative_tax_mny")
    private BigDecimal cumulativeTaxMny; // 累计发票金额
    @TableField(value = "history_tax_mny")
    private BigDecimal historyTaxMny;// 历史发票金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 销售合同金额
    @TableField(value = "cumulative_ratio")
    private BigDecimal cumulativeRatio; // 累计开票比例
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态


    @TableField(exist = false)
    @SubEntity(serviceName = "invoiceDetailService", pidName = "invoiceId")
    private List<InvoiceDetailEntity> invoiceDetailList = new ArrayList<>(); // 发票信息明细表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getInvoiceTax() {
        return invoiceTax;
    }

    public void setInvoiceTax(BigDecimal invoiceTax) {
        this.invoiceTax = invoiceTax;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public BigDecimal getCumulativeTaxMny() {
        return cumulativeTaxMny;
    }

    public void setCumulativeTaxMny(BigDecimal cumulativeTaxMny) {
        this.cumulativeTaxMny = cumulativeTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getCumulativeRatio() {
        return cumulativeRatio;
    }

    public void setCumulativeRatio(BigDecimal cumulativeRatio) {
        this.cumulativeRatio = cumulativeRatio;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<InvoiceDetailEntity> getInvoiceDetailList() {
        return invoiceDetailList;
    }

    public void setInvoiceDetailList(List<InvoiceDetailEntity> invoiceDetailList) {
        this.invoiceDetailList = invoiceDetailList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public BigDecimal getHistoryTaxMny() {
        return historyTaxMny;
    }

    public void setHistoryTaxMny(BigDecimal historyTaxMny) {
        this.historyTaxMny = historyTaxMny;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
}
