/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costReport"})
public class CostReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;

    @RequestMapping(value={"/queryCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCost(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.querySjCostList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelCost"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCost(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.querySjCostList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryFinancec(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.queryFinanceList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.queryFinanceList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getMny(Long projectId) {
        FinanceReportVO sum = this.contractService.queryFinanceSum(projectId);
        if (sum == null) {
            CommonResponse.success((Object)BigDecimal.ZERO);
        }
        if (sum.getReceiveMny() == null) {
            sum.setReceiveMny(BigDecimal.ZERO);
        }
        if (sum.getPaymentMny() == null) {
            sum.setPaymentMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((Object)sum.getReceiveMny().subtract(sum.getPaymentMny()));
    }
}

