package com.ejianc.business.jlcost.payout.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.vo.ContractVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支出合同-合同主表
 *
 * @author generator
 */
public interface IContractService extends IBaseService<ContractEntity> {
    /**
     * 保存或修改信息
     *
     * @param contractVo
     * @return
     */
    CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    ContractVO queryDetail(Long id);

    List<SjCostReportVO> querySjCostList(Page page, QueryWrapper wrapper);

    List<FinanceReportVO> queryFinanceList(Page page, QueryWrapper wrapper);

    FinanceReportVO queryFinanceSum( Long projectId);

}
