package com.ejianc.business.jlcost.finance.service.impl;

import com.ejianc.business.jlcost.finance.consts.ArchiveProjectStatusEnum;
import com.ejianc.business.jlcost.finance.consts.ProjectStatusEnum;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.PayReimburseMapper;
import com.ejianc.business.jlcost.finance.bean.PayReimburseEntity;
import com.ejianc.business.jlcost.finance.service.IPayReimburseService;

import java.util.*;

/**
 * 资金管理-费用报销单
 *
 * @author generator
 */
@Service("payReimburseService")
public class PayReimburseServiceImpl extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity> implements IPayReimburseService {

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Override
    public void updateProjectStatus() {
        // 查询所有报销单
        List<PayReimburseEntity> reimburseList = this.list();
        // 遍历报销单 将项目id存入集合 不重复
        HashSet<Long> projectIds = new HashSet<>();
        reimburseList.forEach(reimburse -> {
            projectIds.add(reimburse.getProjectId());
        });
        // Set转List
        ArrayList<Long> projectIdList = new ArrayList<>(projectIds);
        // 调rpc接口 根据id集合查询项目信息
        List<ProjectArchiveVO> projectList = projectArchiveApi.getProjectArchiveByIds(projectIdList).getData();
        // 遍历项目集合，使用Map集合保存项目中标状态，为Map赋值 statusMap<项目id,项目中标状态>
        Map<Long, String> statusMap = new HashMap<>();
        for (ProjectArchiveVO projectArchiveVO : projectList) {
            /*
             * 项目中标状态：根据项目阶段赋值，实时更新
             * 项目阶段：商机、投标，赋值：投标中
             * 项目阶段：未中标，赋值：未中标
             * 项目阶段：已中标、合同、生产、供货、结算、完工，赋值：已中标
             */
            if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.未中标.getCode())) {
                statusMap.put(projectArchiveVO.getId(), ProjectStatusEnum.未中标.getName());
            } else if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.商机阶段.getCode()) || projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.投标阶段.getCode())) {
                statusMap.put(projectArchiveVO.getId(), ProjectStatusEnum.投标中.getName());
            } else {
                statusMap.put(projectArchiveVO.getId(), ProjectStatusEnum.已中标.getName());
            }
        }
        // 遍历费用报销单 为项目中标状态赋值
        reimburseList.forEach(e -> {
            if (statusMap.get(e.getProjectId()) != null) {
                e.setProjectStatusName(statusMap.get(e.getProjectId()));
                e.setProjectStatus(ProjectStatusEnum.getCodeByName(statusMap.get(e.getProjectId())));
            }
        });
        // 数据库批量更新
        this.updateBatchById(reimburseList);
    }
}
