package com.ejianc.business.jlcost.payout.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.vo.ProjectRecordVO;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支出合同-合同主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    List<SjCostReportVO> querySjCostList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);
    List<FinanceReportVO> queryFinancecList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    FinanceReportVO queryFinancecSum(@Param("projectId") Long projectId);

    List<SjCostReportVO> querySjDetailMny(@Param("projectId") Long projectId);

    List<SjCostReportVO> queryMaterialMny(@Param("projectId") Long projectId);

    List<SjCostReportVO> querySjCostMny(@Param("projectId") Long projectId);

    List<TargetMaterialDetailVO> queryMaterialSum(@Param("projectId") Long projectId,@Param("wbsId") Long wbsId);

    List<TargetMaterialDetailVO> queryMaterialList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("projectId") Long projectId,@Param("wbsId") Long wbsId,@Param("materialId") Long materialId);

    TargetMaterialDetailVO querySjWorkTime(@Param("projectId") Long projectId,@Param("wbsId") Long wbsId);

    List<TargetMaterialDetailVO> querySjWorkTimeList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("projectId") Long projectId,@Param("wbsId") Long wbsId);

    List<ProjectRecordVO> queryProjectList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

}
