/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.service.ITargetDetailService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportCostVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportVO;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costReport"})
public class CostReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetDetailService targetDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/queryCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCost(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.querySjCostList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelCost"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCost(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.querySjCostList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryFinancec(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.queryFinanceList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.queryFinanceList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("financeReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getFinanceMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getFinanceMny(Long projectId) {
        return CommonResponse.success((Object)this.contractService.queryFinanceSum(projectId));
    }

    @RequestMapping(value={"/queryTargetReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TargetReportVO> queryTargetReport(Long projectId) {
        TargetReportVO vo = new TargetReportVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(TargetEntity::getProjectId, (Object)projectId);
        lambda.in(TargetEntity::getBillState, new Object[]{1, 3});
        List targetEntityList = this.targetService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)targetEntityList)) {
            TargetEntity targetEntity = (TargetEntity)((Object)targetEntityList.get(0));
            List<SjCostReportVO> sjList = this.contractService.querySjDetailMny(projectId);
            List<SjCostReportVO> materialList = this.contractService.queryMaterialMny(projectId);
            HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
            HashMap<Long, BigDecimal> materialMap = new HashMap<Long, BigDecimal>();
            BigDecimal sjCostMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(sjList)) {
                for (SjCostReportVO sjvo : sjList) {
                    map.put(sjvo.getCostType(), sjvo.getMny());
                }
            }
            if (CollectionUtils.isNotEmpty(materialList)) {
                for (SjCostReportVO sjvo : materialList) {
                    if (materialMap.containsKey(sjvo.getWbsId())) {
                        BigDecimal materialCostMny = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)materialMap.get(sjvo.getWbsId())), (BigDecimal)sjvo.getMny());
                        materialMap.put(sjvo.getWbsId(), materialCostMny);
                        continue;
                    }
                    materialMap.put(sjvo.getWbsId(), sjvo.getMny());
                }
            }
            vo.setProjectId(projectId);
            vo.setProjectCode(targetEntity.getProjectCode());
            vo.setProjectName(targetEntity.getProjectName());
            vo.setContractMny(targetEntity.getContractMny());
            vo.setContractTaxMny(targetEntity.getContractTaxMny());
            vo.setCostMny(targetEntity.getCostMny());
            vo.setPlanProfitMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getCostMny()));
            LambdaQueryWrapper lambdab = Wrappers.lambdaQuery();
            lambdab.eq(TargetDetailEntity::getTargetId, (Object)targetEntity.getId());
            lambdab.ne(TargetDetailEntity::getRowType, (Object)7);
            List targetDetailEntities = this.targetDetailService.list((Wrapper)lambdab);
            Map<Long, TargetDetailEntity> idMap = targetDetailEntities.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x));
            if (CollectionUtils.isNotEmpty((Collection)targetDetailEntities)) {
                ArrayList resList = new ArrayList();
                HashSet set = new HashSet();
                HashMap<Long, BigDecimal> mbMap = new HashMap<Long, BigDecimal>();
                List list = BeanMapper.mapList((Iterable)targetDetailEntities, TargetReportDetailVO.class);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (TargetReportDetailVO detailVO : list) {
                        if (null == detailVO.getRowType() || 5 != detailVO.getRowType()) continue;
                        Long wbsId = idMap.get(detailVO.getParentId()).getSourceId();
                        if (null == detailVO.getCostType() || 0 != detailVO.getCostType()) continue;
                        if (mbMap.containsKey(wbsId)) {
                            BigDecimal materialCostMny = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)mbMap.get(wbsId)), (BigDecimal)detailVO.getMny());
                            mbMap.put(wbsId, materialCostMny);
                            continue;
                        }
                        mbMap.put(wbsId, detailVO.getMny());
                    }
                }
                list.forEach(e -> {
                    if (null != e.getCostType() && 0 != e.getCostType()) {
                        e.setSjCostMny((BigDecimal)map.get(e.getCostType()));
                        resList.add(e);
                    } else if (null != e.getCostType() && 0 == e.getCostType()) {
                        Long wbsId = ((TargetDetailEntity)((Object)((Object)idMap.get(e.getParentId())))).getSourceId();
                        if (!set.contains(wbsId)) {
                            TargetReportDetailVO detailVO = new TargetReportDetailVO();
                            detailVO.setId(Long.valueOf(wbsId + 99L));
                            detailVO.setCode(((TargetDetailEntity)((Object)((Object)idMap.get(e.getParentId())))).getCode() + "01");
                            detailVO.setName("\u6750\u6599\u8d39");
                            detailVO.setCostType(Integer.valueOf(0));
                            detailVO.setRowLevel(Integer.valueOf(3));
                            detailVO.setRowType(Integer.valueOf(5));
                            detailVO.setSourceId(wbsId);
                            detailVO.setMny((BigDecimal)mbMap.get(wbsId));
                            detailVO.setSjCostMny((BigDecimal)materialMap.get(wbsId));
                            detailVO.setParentId(e.getParentId());
                            resList.add(detailVO);
                            set.add(wbsId);
                        }
                    } else if (null == e.getCostType()) {
                        resList.add(e);
                    }
                });
                resList.forEach(e -> {
                    if (2 == e.getRowLevel()) {
                        e.setSjCostMny(this.getCostMny((TargetReportDetailVO)e, resList, 3));
                    }
                });
                resList.forEach(e -> {
                    if (1 == e.getRowLevel()) {
                        e.setSjCostMny(this.getCostMny((TargetReportDetailVO)e, resList, 2));
                    }
                });
                for (TargetReportDetailVO e2 : resList) {
                    if (1 != e2.getRowLevel()) continue;
                    sjCostMny = ComputeUtil.safeAdd((BigDecimal)sjCostMny, (BigDecimal)e2.getSjCostMny());
                }
                vo.setSjCostMny(sjCostMny);
                vo.setSjProfitMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getSjCostMny()));
                vo.setDetailList(TreeNodeBUtil.buildTree(resList));
            }
            List<SjCostReportVO> costAllList = this.contractService.querySjCostMny(projectId);
            HashMap<Integer, BigDecimal> costMap = new HashMap<Integer, BigDecimal>();
            if (CollectionUtils.isNotEmpty(costAllList)) {
                for (SjCostReportVO sjvo : costAllList) {
                    costMap.put(sjvo.getCostType(), sjvo.getMny());
                }
            }
            vo.setCostList(this.getTargetReportCostVO(targetEntity, vo, costMap));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMaterialSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TargetMaterialDetailVO>> queryMaterialSum(Long projectId, Long wbsId) {
        return CommonResponse.success(this.contractService.queryMaterialSum(projectId, wbsId));
    }

    @RequestMapping(value={"/queryMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryMaterialList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("code");
        fuzzyFields.add("spec");
        fuzzyFields.add("name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Long projectId = Long.valueOf(String.valueOf(param.getParams().get("projectId")));
        Long wbsId = Long.valueOf(String.valueOf(param.getParams().get("wbsId")));
        Long materialId = Long.valueOf(String.valueOf(param.getParams().get("materialId")));
        RecordVOList = this.contractService.queryMaterialList(page, wrapper, projectId, wbsId, materialId);
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryWorkTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryWorkTime(Long projectId, Long wbsId) {
        return CommonResponse.success((Object)this.contractService.queryWorkTime(projectId, wbsId));
    }

    @RequestMapping(value={"/queryWorkTimeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryWorkTimeList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Long projectId = Long.valueOf(String.valueOf(param.getParams().get("projectId")));
        Long wbsId = Long.valueOf(String.valueOf(param.getParams().get("wbsId")));
        RecordVOList = this.contractService.queryWorkTimeList(page, wrapper, projectId, wbsId);
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    public List<TargetReportCostVO> getTargetReportCostVO(TargetEntity targetEntity, TargetReportVO vo, Map<Integer, BigDecimal> costMap) {
        ArrayList<TargetReportCostVO> costList = new ArrayList<TargetReportCostVO>();
        TargetReportCostVO targetReportCostVO = (TargetReportCostVO)BeanMapper.map((Object)((Object)targetEntity), TargetReportCostVO.class);
        targetReportCostVO.setId(Long.valueOf(1L));
        targetReportCostVO.setName("\u76ee\u6807\u6210\u672c");
        targetReportCostVO.setCostMny(vo.getCostMny());
        costList.add(targetReportCostVO);
        TargetReportCostVO targetReportCostVO2 = new TargetReportCostVO();
        targetReportCostVO2.setId(Long.valueOf(2L));
        targetReportCostVO2.setName("\u5b9e\u9645\u6210\u672c");
        targetReportCostVO2.setCostMny(vo.getSjCostMny());
        if (null != costMap) {
            targetReportCostVO2.setMaterialMny(costMap.get(0));
            targetReportCostVO2.setLaborMny(costMap.get(1));
            targetReportCostVO2.setMakeMny(costMap.get(2));
            targetReportCostVO2.setSpecialMny(costMap.get(3));
            targetReportCostVO2.setWxjgMny(costMap.get(4));
            targetReportCostVO2.setWgcpMny(costMap.get(5));
            targetReportCostVO2.setXcsgMny(costMap.get(6));
            targetReportCostVO2.setXczzMny(costMap.get(7));
            targetReportCostVO2.setWbsjMny(costMap.get(8));
            targetReportCostVO2.setTransportMny(costMap.get(9));
            targetReportCostVO2.setZtwbMny(costMap.get(10));
            targetReportCostVO2.setOtherMny(costMap.get(11));
        }
        costList.add(targetReportCostVO2);
        TargetReportCostVO targetReportCostVO3 = new TargetReportCostVO();
        targetReportCostVO3.setId(Long.valueOf(3L));
        targetReportCostVO3.setName("\u76ee\u6807-\u5b9e\u9645");
        targetReportCostVO3.setCostMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getCostMny(), (BigDecimal)targetReportCostVO2.getCostMny()));
        targetReportCostVO3.setMaterialMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getMaterialMny(), (BigDecimal)targetReportCostVO2.getMaterialMny()));
        targetReportCostVO3.setLaborMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getLaborMny(), (BigDecimal)targetReportCostVO2.getLaborMny()));
        targetReportCostVO3.setMakeMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getMakeMny(), (BigDecimal)targetReportCostVO2.getMakeMny()));
        targetReportCostVO3.setSpecialMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getSpecialMny(), (BigDecimal)targetReportCostVO2.getSpecialMny()));
        targetReportCostVO3.setWxjgMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWxjgMny(), (BigDecimal)targetReportCostVO2.getWxjgMny()));
        targetReportCostVO3.setWgcpMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWgcpMny(), (BigDecimal)targetReportCostVO2.getWgcpMny()));
        targetReportCostVO3.setXcsgMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getXcsgMny(), (BigDecimal)targetReportCostVO2.getXcsgMny()));
        targetReportCostVO3.setXczzMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getXczzMny(), (BigDecimal)targetReportCostVO2.getXczzMny()));
        targetReportCostVO3.setWbsjMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWbsjMny(), (BigDecimal)targetReportCostVO2.getWbsjMny()));
        targetReportCostVO3.setTransportMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getTransportMny(), (BigDecimal)targetReportCostVO2.getTransportMny()));
        targetReportCostVO3.setZtwbMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getZtwbMny(), (BigDecimal)targetReportCostVO2.getZtwbMny()));
        targetReportCostVO3.setOtherMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getOtherMny(), (BigDecimal)targetReportCostVO2.getOtherMny()));
        costList.add(targetReportCostVO3);
        return costList;
    }

    public BigDecimal getCostMny(TargetReportDetailVO vo, List<TargetReportDetailVO> list, int rowType) {
        BigDecimal costMny = BigDecimal.ZERO;
        for (TargetReportDetailVO e : list) {
            if (null == e.getRowLevel() || rowType != e.getRowLevel() || !e.getParentId().equals(vo.getId())) continue;
            costMny = ComputeUtil.safeAdd((BigDecimal)costMny, (BigDecimal)e.getSjCostMny());
        }
        return costMny;
    }

    @RequestMapping(value={"/queryProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        RecordVOList = this.contractService.queryProjectList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }
}

