/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetService")
public class TargetServiceImpl
extends BaseServiceImpl<TargetMapper, TargetEntity>
implements ITargetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITargetChangeService changeService;
    private static final String BILL_CODE = "TARGET_COST";
    @Autowired
    private ITargetRecordService recordService;

    @Override
    public TargetVO queryDetail(Long id) {
        TargetEntity entity = (TargetEntity)((Object)super.selectById((Serializable)id));
        TargetVO vo = (TargetVO)BeanMapper.map((Object)((Object)entity), TargetVO.class);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TargetDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        if (entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(TargetChangeEntity::getTargetId, (Object)id);
            lambda.in(TargetChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List entities = this.changeService.list((Wrapper)lambda);
            vo.setRecordList(BeanMapper.mapList((Iterable)entities, TargetChangeVO.class));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetVO> insertOrUpdate(TargetVO saveOrUpdateVO) {
        TargetEntity entity = (TargetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TargetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public CommonResponse<String> checkProjectData(Long projectId, Long id) {
        List billList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        if (null != id) {
            query.ne((Object)"id", (Object)id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(billList = super.list((Wrapper)query))) && billList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u76ee\u6807\u6210\u672c\u5355\u636e\uff0c\u8bf7\u5728\u539f\u5355\u636e\u4e0a\u4fee\u6539\u6216\u53d8\u66f4\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u53ef\u7528\uff01");
    }

    private void resetPid(List<TargetDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TargetDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (TargetDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
    }
}

