package com.ejianc.business.jlcost.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlcost.cost.bean.TargetRecordDetailEntity;
/**
 * 成本管理-目标成本-记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_target_record")
public class TargetRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="target_id")
    private Long targetId; // 原目标成本单据Id
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 销售合同总金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 销售合同总金额（无税）
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 目标成本总金额
    @TableField(value="plan_profit_mny")
    private BigDecimal planProfitMny; // 预计利润
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 材料费
    @TableField(value="labor_mny")
    private BigDecimal laborMny; // 人工费
    @TableField(value="make_mny")
    private BigDecimal makeMny; // 制作费
    @TableField(value="special_mny")
    private BigDecimal specialMny; // 专项费
    @TableField(value="wxjg_mny")
    private BigDecimal wxjgMny; // 外协加工费
    @TableField(value="wgcp_mny")
    private BigDecimal wgcpMny; // 外购产品费
    @TableField(value="xcsg_mny")
    private BigDecimal xcsgMny; // 现场施工费
    @TableField(value="xczz_mny")
    private BigDecimal xczzMny; // 现场制作费
    @TableField(value="wbsj_mny")
    private BigDecimal wbsjMny; // 外部设计费
    @TableField(value="transport_mny")
    private BigDecimal transportMny; // 运费
    @TableField(value="ztwb_mny")
    private BigDecimal ztwbMny; // 整体外包费
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其他费用
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="targetRecordDetailService", pidName = "recordId")//此处有pid="xxx"，默认值pid="pid"
    private List<TargetRecordDetailEntity> detailList = new ArrayList<>(); // 成本管理-目标成本-记录子表
    

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getPlanProfitMny() {
        return planProfitMny;
    }

    public void setPlanProfitMny(BigDecimal planProfitMny) {
        this.planProfitMny = planProfitMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMakeMny() {
        return makeMny;
    }

    public void setMakeMny(BigDecimal makeMny) {
        this.makeMny = makeMny;
    }
    public BigDecimal getSpecialMny() {
        return specialMny;
    }

    public void setSpecialMny(BigDecimal specialMny) {
        this.specialMny = specialMny;
    }
    public BigDecimal getWxjgMny() {
        return wxjgMny;
    }

    public void setWxjgMny(BigDecimal wxjgMny) {
        this.wxjgMny = wxjgMny;
    }
    public BigDecimal getWgcpMny() {
        return wgcpMny;
    }

    public void setWgcpMny(BigDecimal wgcpMny) {
        this.wgcpMny = wgcpMny;
    }
    public BigDecimal getXcsgMny() {
        return xcsgMny;
    }

    public void setXcsgMny(BigDecimal xcsgMny) {
        this.xcsgMny = xcsgMny;
    }
    public BigDecimal getXczzMny() {
        return xczzMny;
    }

    public void setXczzMny(BigDecimal xczzMny) {
        this.xczzMny = xczzMny;
    }
    public BigDecimal getWbsjMny() {
        return wbsjMny;
    }

    public void setWbsjMny(BigDecimal wbsjMny) {
        this.wbsjMny = wbsjMny;
    }
    public BigDecimal getTransportMny() {
        return transportMny;
    }

    public void setTransportMny(BigDecimal transportMny) {
        this.transportMny = transportMny;
    }
    public BigDecimal getZtwbMny() {
        return ztwbMny;
    }

    public void setZtwbMny(BigDecimal ztwbMny) {
        this.ztwbMny = ztwbMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<TargetRecordDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TargetRecordDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
