package com.ejianc.business.jlcost.cost.controller.api;

import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@RestController
@RequestMapping("/api/targetApi/")
public class TargetApi {

    @Autowired
    private ITargetService targetService;

    /**
     * 获项目下各人工工时汇总
     * @return
     */
    @GetMapping(value = "/getLaborTimeByProjectIds")
    public CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(@RequestParam(value = "projectIds") List<Long> projectIds, @RequestParam(value = "productIds") List<Long> productIds) {
        return targetService.getLaborTimeByProjectIds(projectIds, productIds);
    }

    /**
     * 获取零件材料数据
     * @return
     */
    @GetMapping(value = "/getMaterialDataByMaterialIds")
    public CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "productId") Long productId, @RequestParam(value = "materialIds") List<Long> materialIds) {
        return targetService.getMaterialDataByMaterialIds(projectId, productId, materialIds);
    }

}
