package com.ejianc.business.jlcost.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.service.ITargetService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 成本管理-目标成本
 * 
 * @author generator
 * 
 */
@Service("targetService")
public class TargetServiceImpl extends BaseServiceImpl<TargetMapper, TargetEntity> implements ITargetService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITargetChangeService changeService;


    private static final String BILL_CODE = "TARGET_COST";//此处需要根据实际修改
    

    @Autowired
    private ITargetRecordService recordService;

    @Override
    public TargetVO queryDetail(Long id) {
        TargetEntity entity = super.selectById(id);
        TargetVO vo = BeanMapper.map(entity, TargetVO.class);

        //子表
        List<TargetDetailVO> detailList = vo.getDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TargetDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }

        if (entity.getChangeVersion() > 0) {
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<TargetChangeEntity> lambda = Wrappers.<TargetChangeEntity>lambdaQuery();
            lambda.eq(TargetChangeEntity::getTargetId, id);
            lambda.in(TargetChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(TargetChangeEntity::getCreateTime);
            List<TargetChangeEntity> entities = changeService.list(lambda);
            vo.setRecordList(BeanMapper.mapList(entities, TargetChangeVO.class));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetVO> insertOrUpdate(TargetVO saveOrUpdateVO) {
        TargetEntity entity = BeanMapper.map(saveOrUpdateVO, TargetEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //重置父id
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate(entity, false);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    @Override
    public CommonResponse<String> checkProjectData(Long projectId, Long id) {
        QueryWrapper<TargetEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        if (null != id){
            query.ne("id", id);
        }
        List<TargetEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList) && billList.size() > 0){
            return CommonResponse.error("该项目已存在目标成本单据，请在原单据上修改或变更！");
        }else {
            return CommonResponse.success("该项目可用！");
        }
    }



    private void resetPid(List<TargetDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap = new HashMap<>();
            for(TargetDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if (detail.getId() == null){
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for(TargetDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if(StringUtils.isNotEmpty(detail.getTpid())){
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
    }


    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(Long projectId) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getTargetDataByProjectId(projectId);
        return CommonResponse.success("查询该项目下目标成本数据成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProductId(Long projectId, Long productId) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getTargetDataByProductId(projectId, productId);
        return CommonResponse.success("查询该项目下目标成本数据成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>>getMakeMnyByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getMakeMnyByProjectIds(projectIds, productIds);
        return CommonResponse.success("获项目下各制作费（产品）汇总成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getLaborTimeByProjectIds(projectIds, productIds);
        return CommonResponse.success("查询项目下各人工工时汇总成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(Long projectId, Long productId, List<Long> materialIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getMaterialDataByMaterialIds(projectId, productId, materialIds);
        return CommonResponse.success("查询项目下获取零件材料数据汇总成功！", queryTargetDataVOList);
    }


}
