package com.ejianc.business.jlcost.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.service.IPaymentService;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;

/**
 * 资金管理-付款单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payment")
public class PaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PAYMENT";//此处需要根据实际修改

    @Autowired
    private IPaymentService service;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IReceiveService receiveService;


    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaymentVO> saveOrUpdate(@RequestBody PaymentVO saveOrUpdateVO) {
    	PaymentEntity entity = BeanMapper.map(saveOrUpdateVO, PaymentEntity.class);
        LambdaQueryWrapper<PaymentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.notIn(PaymentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdaQueryWrapper.eq(PaymentEntity::getContractId,saveOrUpdateVO.getContractId());
        lambdaQueryWrapper.eq(PaymentEntity::getProjectId,saveOrUpdateVO.getProjectId());
        lambdaQueryWrapper.eq(PaymentEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(PaymentEntity::getId,saveOrUpdateVO.getId());
        }
        List<PaymentEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("当前合同当前项目下存在未提交单据，请提交后再操作！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PaymentVO vo = BeanMapper.map(entity, PaymentVO.class);
        vo.setFinanceMny(contractService.queryFinanceSum(vo.getProjectId()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetail(Long id) {
    	PaymentEntity entity = service.selectById(id);
    	PaymentVO vo = BeanMapper.map(entity, PaymentVO.class);
        vo.setFinanceMny(contractService.queryFinanceSum(vo.getProjectId()));

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PaymentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("paymentType");
        fuzzyFields.add("paymentMethodName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PaymentEntity> page = service.queryPage(param,false);
        IPage<PaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/addPaymentByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentVO> addPaymentByConId(@RequestParam Long id) {
        PaymentVO paymentVO = service.addPaymentByConId(id);
        return CommonResponse.success(paymentVO);
    }

    /**
     * 根据合同主键ID查询变更记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentRecordVO> queryDetailRecord(@RequestParam Long id) {
        PaymentRecordVO recordVO = service.queryChangeRecord(id);
        return CommonResponse.success(recordVO);
    }

    /**
     * 查询项目下收入合同总金额
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/addProjectTotalMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentVO> addProjectTotalMny(@RequestParam Long id, @RequestParam long projectId) {
        PaymentVO paymentVO = service.addProjectTotalMny(id,projectId);
        return CommonResponse.success(paymentVO);
    }


    /**
     * @Description queryTotal 查询累计金额
     * @param
     */
    @RequestMapping(value = "/queryTotal", method = RequestMethod.GET)
    @ResponseBody
    public List<BigDecimal> queryTotal(@PathParam("contractId") Long contractId, @PathParam("projectId") Long projectId) {
//    public BigDecimal queryTotal() {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        LambdaQueryWrapper<ReceiveEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ReceiveEntity::getProjectId, projectId);
        HashMap<String, Parameter> map = new HashMap<>();
        map.put("contractId", new Parameter(QueryParam.EQ, contractId));
        map.put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.setParams(map);
        List<PaymentEntity> paymentEntities = service.queryList(param);
        List<SettleEntity> settleEntities = settleService.queryList(param);
        List<CollectEntity> collectEntities = collectService.queryList(param);
//        List<ReceiveEntity> receiveEntities = receiveService.queryList(param);
        List<ReceiveEntity> receiveEntities = receiveService.list(queryWrapper);
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getProjectId, projectId);
        List<ContractEntity> contractEntities = contractService.list(wrapper);
        BigDecimal addPaymentTaxMny = paymentEntities.stream().map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addSettleTaxMny = settleEntities.stream().map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addCollectTaxMny = collectEntities.stream().map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addReceiveMny = receiveEntities.stream().map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addContractTaxMny = contractEntities.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<BigDecimal> list = new ArrayList<>();
        list.add(addPaymentTaxMny);
        list.add(addSettleTaxMny);
        list.add(addCollectTaxMny);
        list.add(addReceiveMny);
        list.add(addContractTaxMny);
        return list;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("paymentType");
        fuzzyFields.add("paymentMethodName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<PaymentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<PaymentVO> resDatas = BeanMapper.mapList(list, PaymentVO.class);
        for (PaymentVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
            switch (resData.getContractType()) {
                case 1:
                    resData.setContractTypeName("外协加工合同");
                    break;
                case 2:
                    resData.setContractTypeName("成品采购合同");
                    break;
                case 3:
                    resData.setContractTypeName("整体外包合同");
                    break;
                case 4:
                    resData.setContractTypeName("场地或设备租赁合同");
                    break;
                case 5:
                    resData.setContractTypeName("外部检测合同");
                    break;
                case 6:
                    resData.setContractTypeName("外部设计合同");
                    break;
                case 7:
                    resData.setContractTypeName("外部产品认证合同");
                    break;
                case 8:
                    resData.setContractTypeName("劳务分包合同");
                    break;
                case 9:
                    resData.setContractTypeName("设备或材料采购合同");
                    break;
                case 10:
                    resData.setContractTypeName("设备租赁合同");
                    break;

            }
            switch (resData.getPaymentType()) {
                case 1:
                    resData.setPaymentTypeName("预付款");
                    break;
                case 2:
                    resData.setPaymentTypeName("过程结算款");
                    break;
                case 3:
                    resData.setPaymentTypeName("质保金");
                    break;
                case 4:
                    resData.setPaymentTypeName("其他");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Payment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> refPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PaymentEntity> page = service.queryPage(param,false);
        IPage<PaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
