/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlcost.cost.bean.TargetChangeDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.bean.TargetRecordEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetChangeMapper;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.TargetChangeDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetRecordDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetChangeService")
public class TargetChangeServiceImpl
extends BaseServiceImpl<TargetChangeMapper, TargetChangeEntity>
implements ITargetChangeService {
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public TargetChangeVO queryDetailChange(Long targetId) {
        TargetEntity entity = (TargetEntity)((Object)this.targetService.selectById(targetId));
        TargetChangeVO changeVo = (TargetChangeVO)BeanMapper.map((Object)((Object)entity), TargetChangeVO.class);
        changeVo.setTargetId(targetId);
        changeVo.setId(Long.valueOf(IdWorker.getId()));
        changeVo.setBeforeCostMny(changeVo.getCostMny());
        changeVo.setBillState(null);
        changeVo.setBillCode(entity.getBillCode() + "-" + (entity.getChangeVersion() + 1));
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        ArrayList<TargetChangeDetailVO> detailVOList = new ArrayList<TargetChangeDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getDetailList())) {
            for (TargetChangeDetailVO detailVO : changeVo.getDetailList()) {
                detailVO.setRowState("add");
                detailVO.setSourceDetailId(detailVO.getId());
                detailVO.setSourceTargetId(targetId);
                detailVO.setTid(detailVO.getId());
                detailVO.setTpid(detailVO.getParentId() != null ? detailVO.getParentId().toString() : null);
                detailVOList.add(detailVO);
            }
            changeVo.setDetailList(TreeNodeBUtil.buildTree(detailVOList));
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetId), "EJCBT202406000004", "attachMgr", String.valueOf(changeVo.getId()), "EJCBT202406000005", "attachMgr");
        return changeVo;
    }

    @Override
    public CommonResponse<TargetChangeVO> insertOrUpdate(TargetChangeVO saveOrUpdateVO) {
        TargetChangeEntity entity = (TargetChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TargetChangeEntity.class));
        List<TargetChangeDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TargetChangeDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null || "add".equals(detail.getRowState())) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (TargetChangeDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        TargetEntity targetEntity = (TargetEntity)((Object)this.targetService.selectById(entity.getTargetId()));
        targetEntity.setChangeStatus(2);
        targetEntity.setChangeId(entity.getId());
        targetEntity.setChangeCode(entity.getBillCode());
        targetEntity.setChangeVersion(targetEntity.getChangeVersion() + 1);
        this.targetService.saveOrUpdate((Object)targetEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public TargetChangeVO queryDetail(Long id) {
        TargetChangeEntity entity = (TargetChangeEntity)((Object)super.selectById((Serializable)id));
        TargetChangeVO vo = (TargetChangeVO)BeanMapper.map((Object)((Object)entity), TargetChangeVO.class);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TargetChangeDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetRecordVO> queryRecord(Long id) {
        List detailList;
        List targetRecordEntityList = this.recordService.list((Wrapper)new QueryWrapper().eq((Object)"change_id", (Object)id));
        TargetRecordVO recordVO = new TargetRecordVO();
        if (!targetRecordEntityList.isEmpty() && CollectionUtils.isNotEmpty((Collection)(detailList = (recordVO = (TargetRecordVO)BeanMapper.map((Object)this.recordService.selectById(((TargetRecordEntity)((Object)targetRecordEntityList.get(0))).getId()), TargetRecordVO.class)).getDetailList()))) {
            for (TargetRecordDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            recordVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)recordVO);
    }
}

