package com.ejianc.business.jlcost.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlcost.cost.bean.TargetChangeDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.bean.TargetRecordEntity;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.TargetChangeMapper;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 成本管理-目标成本-变更
 * 
 * @author generator
 * 
 */
@Service("targetChangeService")
public class TargetChangeServiceImpl extends BaseServiceImpl<TargetChangeMapper, TargetChangeEntity> implements ITargetChangeService{
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public TargetChangeVO queryDetailChange(Long targetId) {
        TargetEntity entity = targetService.selectById(targetId);
        TargetChangeVO changeVo = BeanMapper.map(entity, TargetChangeVO.class);
        //新增逻辑处理
        changeVo.setTargetId(targetId);
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBeforeCostMny(changeVo.getCostMny());
        changeVo.setBillState(null);
        changeVo.setBillCode(entity.getBillCode() + "-" + (entity.getChangeVersion() + 1));
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);

        List<TargetChangeDetailVO> detailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVo.getDetailList())){
            for (TargetChangeDetailVO detailVO : changeVo.getDetailList()) {
                detailVO.setRowState("add");
                detailVO.setSourceDetailId(detailVO.getId());
                detailVO.setSourceTargetId(targetId);
                detailVO.setTid(detailVO.getId());
                detailVO.setTpid(detailVO.getParentId() != null ? detailVO.getParentId().toString() : null);
                detailVOList.add(detailVO);
            }
            //明细子表排序为树形
            changeVo.setDetailList(TreeNodeBUtil.buildTree(detailVOList));
        }
        //复制附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetId), "EJCBT202406000004", "attachMgr", String.valueOf(changeVo.getId()), "EJCBT202406000005", "attachMgr");
        return changeVo;
    }

    @Override
    public CommonResponse<TargetChangeVO> insertOrUpdate(TargetChangeVO saveOrUpdateVO) {
        TargetChangeEntity entity = BeanMapper.map(saveOrUpdateVO, TargetChangeEntity.class);

        List<TargetChangeDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap = new HashMap<>();
            for(TargetChangeDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if (detail.getId() == null || ("add").equals(detail.getRowState())){
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for(TargetChangeDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if(StringUtils.isNotEmpty(detail.getTpid())){
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
        super.saveOrUpdate(entity, false);
        //回写主表 变更信息
        TargetEntity targetEntity = targetService.selectById(entity.getTargetId());
        targetEntity.setChangeStatus(2);
        targetEntity.setChangeId(entity.getId());
        targetEntity.setChangeCode(entity.getBillCode());
        targetEntity.setChangeVersion(targetEntity.getChangeVersion() + 1);
        targetService.saveOrUpdate(targetEntity);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    public TargetChangeVO queryDetail(Long id) {
        TargetChangeEntity entity = super.selectById(id);
        TargetChangeVO vo = BeanMapper.map(entity, TargetChangeVO.class);
        //子表
        List<TargetChangeDetailVO> detailList = vo.getDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TargetChangeDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetRecordVO> queryRecord(Long id) {
        List<TargetRecordEntity> targetRecordEntityList = recordService.list(new QueryWrapper<TargetRecordEntity>().eq("change_id", id));
        TargetRecordVO recordVO = new TargetRecordVO();
        if (!targetRecordEntityList.isEmpty()) {
            recordVO = BeanMapper.map(recordService.selectById(targetRecordEntityList.get(0).getId()), TargetRecordVO.class);
            //子表
            List<TargetRecordDetailVO> detailList = recordVO.getDetailList();
            //明细子表排序为树形
            if (CollectionUtils.isNotEmpty(detailList)) {
                for (TargetRecordDetailVO detail : detailList) {
                    detail.setTid(detail.getId());
                    detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                }
                recordVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
            }
        }
        return CommonResponse.success("查询详情数据成功！", recordVO);
    }


}
