package com.ejianc.business.jlcost.cost.controller;

import java.io.Serializable;

import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.TargetVO;

/**
 * 成本管理-目标成本
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("target")
public class TargetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TARGET_COST";//此处需要根据实际修改

    @Autowired
    private ITargetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TargetVO> saveOrUpdate(@RequestBody TargetVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TargetVO> queryDetail(Long id) {
        TargetVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TargetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TargetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TargetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TargetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<TargetEntity> page = service.queryPage(param, false);
        IPage<TargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TargetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<TargetVO> voList = BeanMapper.mapList(list, TargetVO.class);

        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setChangeStatusName(e.getChangeStatus() == 1 ? "未变更" : e.getChangeStatus() == 2 ? "变更中" : "已变更" );
        });
        beans.put("records", voList);

        ExcelExport.getInstance().export("Target-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTargetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TargetVO>> refTargetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TargetEntity> page = service.queryPage(param,false);
        IPage<TargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 判断 选择校验 该项目 是否已经有目标成本的单据（含自由态）
     * @return
     */
    @GetMapping(value = "/checkProjectData")
    public CommonResponse<String> checkProjectData(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "id", required = false) Long id) {
        return service.checkProjectData(projectId, id);
    }

    /**
     * 获取项目下各项目费用合计
     * @param projectId
     * @return
     */
    @GetMapping(value = "/getTargetDataByProjectId")
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(@RequestParam(value = "projectId") Long projectId) {
        return service.getTargetDataByProjectId(projectId);
    }

    /**
     * 获取项目下各产品费用合计
     * @param projectId
     * @return
     */
    @GetMapping(value = "/getTargetDataByProductId")
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProductId(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "productId") Long productId) {
        return service.getTargetDataByProductId(projectId, productId);
    }


    /**
     * 获项目下各制作费（产品）
     * @param projectIds
     * @return
     */
    @GetMapping(value = "/getMakeMnyByProjectIds")
    public CommonResponse<List<QueryTargetDataVO>> getMakeMnyByProjectIds(@RequestParam(value = "projectIds") List<Long> projectIds, @RequestParam(value = "productIds") List<Long> productIds) {
        return service.getMakeMnyByProjectIds(projectIds, productIds);
    }


    /**
     * 单据管控-【销售合同金额】管控【目标成本金额】
     * @param vo
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody TargetVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
}
