package com.ejianc.business.jlcost.cost.mapper;

import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 成本管理-目标成本
 * 
 * @author generator
 * 
 */
@Mapper
public interface TargetMapper extends BaseCrudMapper<TargetEntity> {

    List<QueryTargetDataVO> getTargetDataByProjectId(@Param("projectId") Long projectId);

    List<QueryTargetDataVO> getTargetDataByProductId(@Param("projectId") Long projectId, @Param("productId") Long productId);

    List<QueryTargetDataVO> getMakeMnyByProjectIds(@Param("projectIds") List<Long> projectIds, @Param("productIds") List<Long> productIds);

    List<QueryTargetDataVO> getLaborTimeByProjectIds(@Param("projectIds") List<Long> projectIds, @Param("productIds") List<Long> productIds);

    List<QueryTargetDataVO> getMaterialDataByMaterialIds(@Param("projectId") Long projectId, @Param("productId") Long productId, @Param("materialIds") List<Long>  materialIds);
}
