package com.ejianc.business.jlcost.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 资金管理-收票登记明细
 *
 * @author generator
 *
 */
 @TableName("ejc_finance_collect_detail")
public class CollectDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="collect_id")
    private Long collectId; // 主表ID
    @TableField(value="number")
    private String number; // 发票号码
    @TableField(value="code")
    private String code; // 发票代码
    @TableField(value="invoice_date")
    private Date invoiceDate; // 开票日期
    @TableField(value="mny")
    private BigDecimal mny; // 发票金额（不含税）
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 价税合计
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="uppercase")
    private String uppercase; // 价税合计大写
    @TableField(value="detail_memo")
    private String detailMemo; // 备注




    public Long getCollectId() {
        return collectId;
    }

    public void setCollectId(Long collectId) {
        this.collectId = collectId;
    }
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getUppercase() {
        return uppercase;
    }

    public void setUppercase(String uppercase) {
        this.uppercase = uppercase;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

}
