package com.ejianc.business.jlcost.cost.service;

import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 成本管理-目标成本
 * 
 * @author generator
 * 
 */
public interface ITargetService extends IBaseService<TargetEntity> {

    TargetVO queryDetail(Long id);

    CommonResponse<TargetVO> insertOrUpdate(TargetVO saveOrUpdateVO);

    CommonResponse<String> checkProjectData(Long projectId, Long id);

    CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(Long projectId);

    CommonResponse<List<QueryTargetDataVO>> getTargetDataByProductId(Long projectId, Long productId);

    CommonResponse<List<QueryTargetDataVO>> getMakeMnyByProjectIds(List<Long> projectIds, List<Long> productIds);

    CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(List<Long> projectIds, List<Long> productIds);

    CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(Long projectId, Long productId, List<Long> materialIds);

    ParamsCheckVO checkParams(TargetVO vo);
}
