package com.ejianc.business.jlcost.finance.controller;

import java.io.Serializable;

import cn.hutool.Hutool;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.api.R;
import com.ejianc.business.jlcost.finance.consts.ArchiveProjectStatusEnum;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlcost.finance.bean.PayReimburseEntity;
import com.ejianc.business.jlcost.finance.service.IPayReimburseService;
import com.ejianc.business.jlcost.finance.vo.PayReimburseVO;

/**
 * 资金管理-费用报销单
 *
 * @author generator
 */
@Controller
@RequestMapping("payReimburse")
public class PayReimburseController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Payreimburse_Code";// 此处需要根据实际修改

    @Autowired
    private IPayReimburseService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IRoleApi roleApi;

    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-Smwe6l0001";

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO saveOrUpdateVO) {
        PayReimburseEntity entity = BeanMapper.map(saveOrUpdateVO, PayReimburseEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());// 此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 根据项目阶段 设置项目中标状态
        if ((entity.getProjectStage().toString()).equals(ArchiveProjectStatusEnum.未中标.getCode())) {
            entity.setProjectStatus(2);
            entity.setProjectStatusName("未中标");
        } else if ((entity.getProjectStage().toString()).equals(ArchiveProjectStatusEnum.商机阶段.getCode()) || (entity.getProjectStage().toString()).equals(ArchiveProjectStatusEnum.投标阶段.getCode())) {
            entity.setProjectStatus(1);
            entity.setProjectStatusName("投标中");
        } else {
            entity.setProjectStatus(3);
            entity.setProjectStatusName("已中标");
        }
        service.saveOrUpdate(entity, false);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseEntity entity = service.selectById(id);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayReimburseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayReimburseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayReimburseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 根据当前用户角色判断是都可以查看全部备用金报销单
        if (!canViewAll()) {
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }
        IPage<PayReimburseEntity> page = service.queryPage(param, false);
        IPage<PayReimburseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PayReimburseVO> list = BeanMapper.mapList(page.getRecords(), PayReimburseVO.class);
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!canViewAll()) {
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<PayReimburseEntity> list = service.queryList(param);
        // 字段翻译
        List<PayReimburseVO> resDatas = BeanMapper.mapList(list, PayReimburseVO.class);

        for (PayReimburseVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("PayReimburse-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPayReimburseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayReimburseVO>> refPayReimburseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayReimburseEntity> page = service.queryPage(param, false);
        IPage<PayReimburseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayReimburseVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @description: 根据当前用户角色判断是都可以查看全部备用金报销单
     * @return: java.lang.Boolean
     * @author songlx
     * @date: 2022/7/26
     */
    public Boolean canViewAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode())) {
                            return Boolean.TRUE;
                        }
                    }
                }
            }
        }
        return Boolean.FALSE;
    }


    /**
     * @Description 定时任务-更新项目中标状态
     */
    @RequestMapping(value = "/updateProjectStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateProjectStatus() {
        logger.info("定时更新费用报销单-------项目中标状态");
        service.updateProjectStatus();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return CommonResponse.success("数据加载成功", simpleDateFormat.format(new Date()));
    }


    /**
     * 单据管控-【目标成本-现场施工费】管控【实际现场施工费】
     * @param vo
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PayReimburseVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
}
