/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetService")
public class TargetServiceImpl
extends BaseServiceImpl<TargetMapper, TargetEntity>
implements ITargetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITargetChangeService changeService;
    private static final String BILL_CODE = "TARGET_COST";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String XSHT_MNY_PARAM_CODE = "P-kLiO450011";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ITargetRecordService recordService;

    @Override
    public TargetVO queryDetail(Long id) {
        TargetEntity entity = (TargetEntity)((Object)super.selectById((Serializable)id));
        TargetVO vo = (TargetVO)BeanMapper.map((Object)((Object)entity), TargetVO.class);
        List detailList = vo.getDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TargetDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        if (entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(TargetChangeEntity::getTargetId, (Object)id);
            lambda.in(TargetChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List entities = this.changeService.list((Wrapper)lambda);
            vo.setRecordList(BeanMapper.mapList((Iterable)entities, TargetChangeVO.class));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetVO> insertOrUpdate(TargetVO saveOrUpdateVO) {
        TargetEntity entity = (TargetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TargetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public CommonResponse<String> checkProjectData(Long projectId, Long id) {
        List billList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        if (null != id) {
            query.ne((Object)"id", (Object)id);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(billList = super.list((Wrapper)query))) && billList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u76ee\u6807\u6210\u672c\u5355\u636e\uff0c\u8bf7\u5728\u539f\u5355\u636e\u4e0a\u4fee\u6539\u6216\u53d8\u66f4\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u53ef\u7528\uff01");
    }

    private void resetPid(List<TargetDetailEntity> detailList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TargetDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (TargetDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(Long projectId) {
        List<QueryTargetDataVO> queryTargetDataVOList = ((TargetMapper)this.baseMapper).getTargetDataByProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be5\u9879\u76ee\u4e0b\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProductId(Long projectId, Long productId) {
        List<QueryTargetDataVO> queryTargetDataVOList = ((TargetMapper)this.baseMapper).getTargetDataByProductId(projectId, productId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be5\u9879\u76ee\u4e0b\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getMakeMnyByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = ((TargetMapper)this.baseMapper).getMakeMnyByProjectIds(projectIds, productIds);
        return CommonResponse.success((String)"\u83b7\u9879\u76ee\u4e0b\u5404\u5236\u4f5c\u8d39\uff08\u4ea7\u54c1\uff09\u6c47\u603b\u6210\u529f\uff01", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = ((TargetMapper)this.baseMapper).getLaborTimeByProjectIds(projectIds, productIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4e0b\u5404\u4eba\u5de5\u5de5\u65f6\u6c47\u603b\u6210\u529f\uff01", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(Long projectId, Long productId, List<Long> materialIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = ((TargetMapper)this.baseMapper).getMaterialDataByMaterialIds(projectId, productId, materialIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4e0b\u83b7\u53d6\u96f6\u4ef6\u6750\u6599\u6570\u636e\u6c47\u603b\u6210\u529f\uff01", queryTargetDataVOList);
    }

    @Override
    public ParamsCheckVO checkParams(TargetVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(TargetVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal mny = vo.getCostMny();
        TargetVO targetVO = ((TargetMapper)this.baseMapper).queryContractTaxMnyByProjectId(vo.getProjectId());
        if (null == targetVO || null == targetVO.getContractTaxMny()) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = targetVO.getContractTaxMny();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(XSHT_MNY_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u9500\u552e\u5408\u540c\u91d1\u989d\u3011\u7ba1\u63a7\u3010\u76ee\u6807\u6210\u672c\u91d1\u989d\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\u8d85\u9500\u552e\u5408\u540c\u603b\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9500\u552e\u5408\u540c\u603b\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append("\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

