/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.payout.bean.BillData;
import com.ejianc.business.jlcost.payout.bean.ContractChangeEntity;
import com.ejianc.business.jlcost.payout.bean.ContractClauseEntity;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.ContractRecordEntity;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;
import com.ejianc.business.jlcost.payout.service.IContractClauseService;
import com.ejianc.business.jlcost.payout.service.IContractRecordService;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChange")
public class ContractChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractRecordService contractRecordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ContractRecordEntity recordEntity = (ContractRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        BillData billData = this.contractChangeService.getContractBillCodeAndType((ContractChangeVO)BeanMapper.map((Object)((Object)contractEntity), ContractChangeVO.class));
        this.attachmentApi.copyFiles(String.valueOf(contractEntity.getId()), billData.getBillTypeStr(), "payoutContract", String.valueOf(recordEntity.getId()), billData.getRecordBillTypeStr(), "contractRecord", true);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPerformanceStatus(changeEntity.getPerformanceStatus());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"contract_id", (Object)changeEntity.getContractId());
        this.contractClauseService.remove((Wrapper)deleteWrapper);
        contractEntity.setContractClauseList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getContractDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), ContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> vo.setId(null));
            contractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), ContractClauseEntity.class));
        }
        boolean flag = this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            this.attachmentApi.copyFiles(String.valueOf(billId), billData.getChangeBillTypeStr(), "contractChange", String.valueOf(contractEntity.getId()), billData.getBillTypeStr(), "payoutContract", true);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

