package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.bean.ProductDetailEntity;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.mapper.ProductDetailMapper;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.ProductDetailVO;
import com.ejianc.business.jlcost.cost.vo.ProductVO;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.ProductMapper;
import com.ejianc.business.jlcost.cost.bean.ProductEntity;
import com.ejianc.business.jlcost.cost.service.IProductService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 成本管理-产品制作费用单
 *
 * @author generator
 */
@Service("productService")
public class ProductServiceImpl extends BaseServiceImpl<ProductMapper, ProductEntity> implements IProductService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITargetService targetService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ProductMapper productMapper;

    @Autowired
    private ProductDetailMapper detailMapper;
    private static final String CPZZF_MNY_PARAM_CODE = "P-jBXO0v0009";//【目标成本-产品制作费】管控【产品实际制作费】

    @Override
    public ParamsCheckVO checkParams(ProductVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//单据管控-【目标成本-产品制作费】管控【产品实际制作费】产品制作费用单

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;

    }


    private List<ParamsCheckVO> checkParamsByMny(ProductVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        List<ProductDetailVO> list = vo.getProductDetailList();
        List<Long> projectIds = new ArrayList<>();
        List<Long> productIds = new ArrayList<>();
        BigDecimal total = new BigDecimal(0);
        for (ProductDetailVO productDetailVO : list) {
            projectIds.add(productDetailVO.getProjectId());
            productIds.add(productDetailVO.getProductId());
            total = total.add(productDetailVO.getOtherMny());
        }

        BigDecimal mny = total;//本期制作费总额
        BigDecimal targetMny;//专项费
        BigDecimal totalMny = mny;// 默认赋值本次


        List<Long> projectIdsList = projectIds.stream().distinct().collect(Collectors.toList());
        List<Long> productIdsList = productIds.stream().distinct().collect(Collectors.toList());

        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getMakeMnyByProjectIds(projectIdsList, productIdsList);

        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标金额信息失败！");
        }

        // 未编制目标成本或目标成本中没有该产品的制作费时不管控；
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }

        //获取目标成本的 总金额
        HashMap<Integer, BigDecimal> map = new HashMap<>();
        HashMap<String, BigDecimal> decimalHashMap = new HashMap<>();
        for (QueryTargetDataVO queryTargetDataVO : targetDataList) {

            if(map.containsKey(queryTargetDataVO.getCostType())){
                BigDecimal bigDecimal = map.get(queryTargetDataVO.getCostType());
                bigDecimal=bigDecimal.add(queryTargetDataVO.getMny());
                map.put(queryTargetDataVO.getCostType(),bigDecimal);
            }else {
                map.put(queryTargetDataVO.getCostType(),queryTargetDataVO.getMny());
            }

            //获取  每一个产品在目标成本中的 金额
            String key= String.valueOf(queryTargetDataVO.getProjectId()+queryTargetDataVO.getProductId());
            if(decimalHashMap.containsKey(key)){
                continue;
            }else {
                decimalHashMap.put(key,queryTargetDataVO.getMny());
            }
        }

        if (!map.containsKey(CostTypeEnum.制作费.getCode())) {
            return paramsCheckVOS;
        }
        //目标金额(总)
        targetMny = map.get(CostTypeEnum.制作费.getCode());


        //查询累计
        LambdaQueryWrapper<ProductDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProductDetailEntity::getDr, 0)
                .in(ProductDetailEntity::getProjectId,projectIdsList)
                .in(ProductDetailEntity::getProductId,productIdsList);

        List<ProductDetailEntity> detailEntities = detailMapper.selectList(wrapper);

        for (ProductDetailEntity detailEntity : detailEntities) {
            totalMny = ComputeUtil.safeAdd(totalMny, detailEntity.getOtherMny());
        }


        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CPZZF_MNY_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-产品制作费】管控【产品实际制作费】：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();

                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    for (ProductDetailVO productDetailVO : vo.getProductDetailList()) {

                        String key= String.valueOf(productDetailVO.getProjectId()+productDetailVO.getProductId());
                        BigDecimal decimal = decimalHashMap.get(key);

//                        BigDecimal price = productDetailVO.getOtherMny() == null ? BigDecimal.ZERO : productDetailVO.getOtherMny().setScale(4, BigDecimal.ROUND_HALF_UP);
//                        BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                       //累计>目标
                       if (totalMny.compareTo(targetMny) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem(productDetailVO.getProjectName()+"-"+productDetailVO.getProductName()+"制作费超额预警");
                            paramsCheckDsVO.setWarnName("产品制作费超目标成本产品制作费");
                            StringBuffer stringBuffer = new StringBuffer();
                           String text = "超出金额："+ComputeUtil.safeSub(totalMny, decimal).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                           String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                            stringBuffer.append("累计制作费金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
//                                    .append("元，目标成本制作费金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("元，目标成本制作费金额：").append(decimal.setScale(2, BigDecimal.ROUND_HALF_UP))
                                    .append("元，管控比例：").append(roleValue).append("%，")
//                                    .append("超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
//                                    .append("超出金额：").append(ComputeUtil.safeSub(totalMny, decimal).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                                    .append(redText);
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
}
