package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.service.ITargetService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 成本管理-目标成本
 * 
 * @author generator
 * 
 */
@Service("targetService")
public class TargetServiceImpl extends BaseServiceImpl<TargetMapper, TargetEntity> implements ITargetService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITargetChangeService changeService;


    private static final String BILL_CODE = "TARGET_COST";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String XSHT_MNY_PARAM_CODE = "P-kLiO450011";//【销售合同金额】管控【目标成本金额】

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ITargetRecordService recordService;

    @Override
    public TargetVO queryDetail(Long id) {
        TargetEntity entity = super.selectById(id);
        TargetVO vo = BeanMapper.map(entity, TargetVO.class);

        //子表
        List<TargetDetailVO> detailList = vo.getDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TargetDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }

        if (entity.getChangeVersion() > 0) {
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<TargetChangeEntity> lambda = Wrappers.<TargetChangeEntity>lambdaQuery();
            lambda.eq(TargetChangeEntity::getTargetId, id);
            lambda.in(TargetChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(TargetChangeEntity::getCreateTime);
            List<TargetChangeEntity> entities = changeService.list(lambda);
            vo.setRecordList(BeanMapper.mapList(entities, TargetChangeVO.class));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetVO> insertOrUpdate(TargetVO saveOrUpdateVO) {
        TargetEntity entity = BeanMapper.map(saveOrUpdateVO, TargetEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //重置父id
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate(entity, false);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    @Override
    public CommonResponse<String> checkProjectData(Long projectId, Long id) {
        QueryWrapper<TargetEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        if (null != id){
            query.ne("id", id);
        }
        List<TargetEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList) && billList.size() > 0){
            return CommonResponse.error("该项目已存在目标成本单据，请在原单据上修改或变更！");
        }else {
            return CommonResponse.success("该项目可用！");
        }
    }



    private void resetPid(List<TargetDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap = new HashMap<>();
            for(TargetDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if (detail.getId() == null){
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for(TargetDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if(StringUtils.isNotEmpty(detail.getTpid())){
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
    }


    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(Long projectId) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getTargetDataByProjectId(projectId);
        return CommonResponse.success("查询该项目下目标成本数据成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getTargetDataByProductId(Long projectId, Long productId) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getTargetDataByProductId(projectId, productId);
        return CommonResponse.success("查询该项目下目标成本数据成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>>getMakeMnyByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getMakeMnyByProjectIds(projectIds, productIds);
        return CommonResponse.success("获项目下各制作费（产品）汇总成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(List<Long> projectIds, List<Long> productIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getLaborTimeByProjectIds(projectIds, productIds);
        return CommonResponse.success("查询项目下各人工工时汇总成功！", queryTargetDataVOList);
    }

    @Override
    public CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(Long projectId, Long productId, List<Long> materialIds) {
        List<QueryTargetDataVO> queryTargetDataVOList = baseMapper.getMaterialDataByMaterialIds(projectId, productId, materialIds);
        return CommonResponse.success("查询项目下获取零件材料数据汇总成功！", queryTargetDataVOList);
    }

    @Override
    public ParamsCheckVO checkParams(TargetVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【销售合同金额】管控【目标成本金额】
        /*添加参数控制区域---*/

        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(TargetVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getCostMny();//目标成本总金额

        TargetVO targetVO = baseMapper.queryContractTaxMnyByProjectId(vo.getProjectId());
        if (null == targetVO || null == targetVO.getContractTaxMny()){
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = targetVO.getContractTaxMny();//销售合同金额

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(XSHT_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【销售合同金额】管控【目标成本金额】："+ JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("目标成本总金额超额预警");
                        paramsCheckDsVO.setWarnName("目标成本总金额超销售合同总金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(mny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("目标成本总金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，销售合同总金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }


}
