package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.OtherVO;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.OtherMapper;
import com.ejianc.business.jlcost.cost.bean.OtherEntity;
import com.ejianc.business.jlcost.cost.service.IOtherService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 成本管理-其他费用单
 * 
 * @author generator
 * 
 */
@Service("otherService")
public class OtherServiceImpl extends BaseServiceImpl<OtherMapper, OtherEntity> implements IOtherService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String QTFY_MNY_PARAM_CODE = "P-8iII1X0006";//【目标成本-其他费用】管控【实际其他费用】

    @Autowired
    private ITargetService targetService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private OtherMapper otherMapper;

    @Override
    public ParamsCheckVO checkParams(OtherVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【目标成本-其他费用】管控【实际其他费用】

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(OtherVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getMny();//本次其他费用单费用金额
        BigDecimal targetMny;//目标成本其他费用
        BigDecimal totalMny = mny;//累计其他费用  默认赋值本次

        //1.查询目标成本 其他费用
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()){
            throw new BusinessException("获取目标成本费用信息失败！");
        }

        //未编制目标成本或目标成本中没有其他费用时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)){
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.其他费用.getCode())){
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.其他费用.getCode());

        //2.查询累计其他费用
        List<SjCostReportVO> queryDataList = otherMapper.getMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)){
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)){
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(QTFY_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-其他费用】管控【实际其他费用】："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("其他费用超额预警");
                        paramsCheckDsVO.setWarnName("项目其他费用超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计其他费用金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本其他费用金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
}
