package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlcost.cost.bean.TargetChangeDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.bean.TargetRecordEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.cost.mapper.TargetChangeMapper;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;

import java.math.BigDecimal;
import java.util.*;

/**
 * 成本管理-目标成本-变更
 * 
 * @author generator
 * 
 */
@Service("targetChangeService")
public class TargetChangeServiceImpl extends BaseServiceImpl<TargetChangeMapper, TargetChangeEntity> implements ITargetChangeService{
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String XSHT_MNY_PARAM_CODE = "P-kLiO450011";//【销售合同金额】管控【目标成本金额】

    @Autowired
    private TargetMapper targetMapper;

    @Override
    public TargetChangeVO queryDetailChange(Long targetId) {
        TargetEntity entity = targetService.selectById(targetId);
        TargetChangeVO changeVo = BeanMapper.map(entity, TargetChangeVO.class);
        //新增逻辑处理
        changeVo.setTargetId(targetId);
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBeforeCostMny(changeVo.getCostMny());
        changeVo.setBillState(null);
        changeVo.setBillCode(entity.getBillCode() + "-" + (entity.getChangeVersion() + 1));
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);

        List<TargetChangeDetailVO> detailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVo.getDetailList())){
            for (TargetChangeDetailVO detailVO : changeVo.getDetailList()) {
                detailVO.setRowState("add");
                detailVO.setSourceDetailId(detailVO.getId());
                detailVO.setSourceTargetId(targetId);
                detailVO.setTid(detailVO.getId());
                detailVO.setTpid(detailVO.getParentId() != null ? detailVO.getParentId().toString() : null);
                detailVOList.add(detailVO);
            }
            //明细子表排序为树形
            changeVo.setDetailList(TreeNodeBUtil.buildTree(detailVOList));
        }
        //复制附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetId), "EJCBT202406000004", "attachMgr", String.valueOf(changeVo.getId()), "EJCBT202406000005", "attachMgr");
        return changeVo;
    }

    @Override
    public CommonResponse<TargetChangeVO> insertOrUpdate(TargetChangeVO saveOrUpdateVO) {
        TargetChangeEntity entity = BeanMapper.map(saveOrUpdateVO, TargetChangeEntity.class);

        List<TargetChangeDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap = new HashMap<>();
            for(TargetChangeDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if (detail.getId() == null || ("add").equals(detail.getRowState())){
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for(TargetChangeDetailEntity detail : detailList){
                if (!("del").equals(detail.getRowState())){
                    if(StringUtils.isNotEmpty(detail.getTpid())){
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
        super.saveOrUpdate(entity, false);
        //回写主表 变更信息
        TargetEntity targetEntity = targetService.selectById(entity.getTargetId());
        targetEntity.setChangeStatus(2);
        targetEntity.setChangeId(entity.getId());
        targetEntity.setChangeCode(entity.getBillCode());
        targetEntity.setChangeVersion(targetEntity.getChangeVersion() + 1);
        targetService.saveOrUpdate(targetEntity);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    public TargetChangeVO queryDetail(Long id) {
        TargetChangeEntity entity = super.selectById(id);
        TargetChangeVO vo = BeanMapper.map(entity, TargetChangeVO.class);
        //子表
        List<TargetChangeDetailVO> detailList = vo.getDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TargetChangeDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetRecordVO> queryRecord(Long id) {
        List<TargetRecordEntity> targetRecordEntityList = recordService.list(new QueryWrapper<TargetRecordEntity>().eq("change_id", id));
        TargetRecordVO recordVO = new TargetRecordVO();
        if (!targetRecordEntityList.isEmpty()) {
            recordVO = BeanMapper.map(recordService.selectById(targetRecordEntityList.get(0).getId()), TargetRecordVO.class);
            //子表
            List<TargetRecordDetailVO> detailList = recordVO.getDetailList();
            //明细子表排序为树形
            if (CollectionUtils.isNotEmpty(detailList)) {
                for (TargetRecordDetailVO detail : detailList) {
                    detail.setTid(detail.getId());
                    detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                }
                recordVO.setDetailList(TreeNodeBUtil.buildTree(detailList));
            }
        }
        return CommonResponse.success("查询详情数据成功！", recordVO);
    }

    @Override
    public ParamsCheckVO checkParams(TargetChangeVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【目标成本-现场施工费】管控【实际现场施工费】
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(TargetChangeVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getCostMny();//目标成本总金额

        TargetVO targetVO = targetMapper.queryContractTaxMnyByProjectId(vo.getProjectId());
        if (null == targetVO || null == targetVO.getContractTaxMny()){
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = targetVO.getContractTaxMny();//销售合同金额

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(XSHT_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【销售合同金额】管控【目标成本金额】："+ JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("目标成本总金额超额预警");
                        paramsCheckDsVO.setWarnName("目标成本总金额超销售合同总金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(mny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("目标成本总金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，销售合同总金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }


}
