package com.ejianc.business.jlcost.payout.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.finance.vo.ReimburseVO;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.OtherVO;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.finance.mapper.ReimburseMapper;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleSourceTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.SettleMapper;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 支出结算-主表
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    @Autowired
    private IContractService contractService;
    @Autowired
    private ITargetService targetService;

    @Autowired
    private SettleMapper settleMapper;



    @Autowired
    private IParamConfigApi paramConfigApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CPZX_MNY_PARAM_CODE = "P-7MAG850004";//【目标成本-产品专项费】管控【产品实际专项费】外部检测结算、外部产品认证结算
    private static final String WXJG_MNY_PARAM_CODE = "P-4wl6550007";//【目标成本-产品外协加工费】管控【产品实际外协加工费】外协加工结算
    private static final String CPCG_MNY_PARAM_CODE = "P-Oy5o9U0008";//【目标成本-产品外购产品费】管控【产品实际外购产品费】成品采购结算
    private static final String WBSJF_MNY_PARAM_CODE = "P-onQ7dF0003";//【目标成本-外部设计费】管控【实际外部设计费】
    private static final String XCSGF_MNY_PARAM_CODE = "P-50GO4a0002";//【目标成本-现场施工费】管控【实际现场施工费】

    @Autowired
    private ReimburseMapper reimburseMapper;


    @Override
    public ParamsCheckVO checkWbsjParams(SettleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkWbsjParamsByMny(vo));//【目标成本-外部设计费】管控【实际外部设计费】



        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbsjParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本次外部设计结算单结算金额
        BigDecimal targetMny;//目标成本外部设计费金额
        BigDecimal totalMny = mny;//累计外部设计费  默认赋值本次

        //1.查询目标成本 外部设计费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()){
            throw new BusinessException("获取目标成本费用信息失败！");
        }

        //未编制目标成本或目标成本中没有外部设计费时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)){
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.外部设计费.getCode())){
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.外部设计费.getCode());

        //2.查询累计外部设计费
        List<SjCostReportVO> queryDataList = settleMapper.getWbsjMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)){
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)){
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(WBSJF_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-外部设计费】管控【实际外部设计费】："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("外部设计费超额预警");
                        paramsCheckDsVO.setWarnName("项目外部设计费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                        String targetMnyStr = targetMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                        String text = "超出金额：" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计外部设计费金额：").append(totalMnyStr)
                                .append("元，目标成本外部设计费金额：").append(targetMnyStr)
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
    @Override
    public SettleVO contToSettle(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        SettleVO settleVO = BeanMapper.map(contractEntity, SettleVO.class);
        settleVO.setId(null);
        settleVO.setBillCode(null);
        settleVO.setCreateTime(null);
        settleVO.setCreateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setMemo(null);
        settleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        settleVO.setSettleDate(new Date());
        settleVO.setSettleBillType(contractEntity.getContractType());
        settleVO.setContractId(contractId);
        settleVO.setContractCode(contractEntity.getBillCode());
        settleVO.setContractTaxRate(contractEntity.getTaxRate());
        settleVO.setSettleType(1);
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            SettleVO result = querySumMny(contractId, contractEntity.getProjectId());
            settleVO.setSumSettleMny(result.getSumSettleMny());
            settleVO.setSumSettleTaxMny(result.getSumSettleTaxMny());
            settleVO.setSumSettleAllMny(result.getSumSettleMny());
            settleVO.setSumSettleAllTaxMny(result.getSumSettleTaxMny());
        }

        List<SettleDetailVO> detailList = new ArrayList<>();
        for (ContractDetailEntity detailEntity : contractEntity.getContractDetailList()) {
            SettleDetailVO detailVO = BeanMapper.map(detailEntity, SettleDetailVO.class);
            detailVO.setId(IdWorker.getId());
            detailVO.setCreateTime(null);
            detailVO.setCreateUserCode(null);
            detailVO.setUpdateTime(null);
            detailVO.setUpdateUserCode(null);
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setNum(null);
            detailVO.setPrice(detailEntity.getDetailPrice());
            detailVO.setTaxPrice(detailEntity.getDetailTaxPrice());
            detailVO.setTaxRate(contractEntity.getTaxRate());
            detailVO.setSourceId(String.valueOf(detailEntity.getId()));
            detailVO.setSourceType(String.valueOf(SettleSourceTypeEnum.合同清单.getCode()));
            detailVO.setRowState("add");
            detailList.add(detailVO);
        }
        settleVO.setDetailList(detailList);
        return settleVO;
    }

    @Override
    public SettleVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.eq(SettleEntity::getProjectId, projectId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> list = list(queryWrapper);
        SettleVO settleVO = new SettleVO();
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        for (SettleEntity entity : list) {
            sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, entity.getSettleMny());
            sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, entity.getSettleTaxMny());
        }
        settleVO.setSumSettleMny(sumSettleMny);
        settleVO.setSumSettleTaxMny(sumSettleTaxMny);
        return settleVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", contractEntity.getChangeStatus());
        jsonObject.put("billState", contractEntity.getBillState());
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List<SettleEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : list) {
                sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", sumSettleTaxMny);
            jsonObject.put("settleTaxScale", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(sumSettleTaxMny, contractEntity.getContractTaxMny()), BigDecimal.valueOf(100)));
            jsonObject.put("detailList", settleVOS);
        }
        return jsonObject;
    }

    @Override
    public ParamsCheckVO checkLwfbSbclSbzlParams(SettleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkXcsgParamsByMny(vo));//【目标成本-现场施工费】管控【实际现场施工费】
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkXcsgParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本次结算
        BigDecimal targetMny;//目标成本现场施工费金额
        BigDecimal totalMny = mny;//累计现场施工费  默认赋值本次

        //1.查询目标成本 现场施工费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()){
            throw new BusinessException("获取目标成本费用信息失败！");
        }

        //未编制目标成本或目标成本中没有现场施工费时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)){
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.现场施工费.getCode())){
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.现场施工费.getCode());

        //2.查询累计现场施工费
        List<SjCostReportVO> queryDataList = reimburseMapper.getMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)){
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)){
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(XCSGF_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-现场施工费】管控【实际现场施工费】："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("现场施工费超额预警");
                        paramsCheckDsVO.setWarnName("项目现场施工费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计现场施工费金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本现场施工费金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWbjcParams(SettleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkWbjcParamsByMny(vo));//单据管控-【目标成本-产品专项费】管控【产品实际专项费】外部检测结算

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbjcParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本期结算金额
        BigDecimal targetMny;//专项费
        BigDecimal totalMny = mny;//累计本期结算金额  默认赋值本次

        //1.查询目标成本 现场施工费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标本期结算金额信息失败！");
        }

        // 未编制目标成本或目标成本中没有该产品的制作费时不管控；
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.专项费.getCode())) {
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.专项费.getCode());

        //2.查询累计
        List<SjCostReportVO> queryDataList = settleMapper.getWbjcMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)) {
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CPZX_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-产品专项费】管控【产品实际专项费】：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("【产品】专项费超额预警");
                        paramsCheckDsVO.setWarnName("产品专项费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计专项费结算金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本专项费金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWbcpParams(SettleVO vo) {

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkWbcpParamsByMny(vo));//单据管控-【目标成本-产品专项费】管控【产品实际专项费】外部产品认证结算

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbcpParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本期结算金额
        BigDecimal targetMny;//专项费
        BigDecimal totalMny = mny;//累计本期结算金额  默认赋值本次

        //1.查询目标成本 现场施工费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标本期结算金额信息失败！");
        }

        // 未编制目标成本或目标成本中没有该产品的制作费时不管控；
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.专项费.getCode())) {
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.专项费.getCode());

        //2.查询累计
        List<SjCostReportVO> queryDataList = settleMapper.getWbcpMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)) {
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CPZX_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-产品专项费】管控【产品实际专项费】：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("【产品】专项费超额预警");
                        paramsCheckDsVO.setWarnName("产品专项费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计专项费结算金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本专项费金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWxjgParams(SettleVO vo) {

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkWxjgParamsByMny(vo));//单据管控-【目标成本-产品外协加工费】管控【产品实际外协加工费】

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;

    }

    private List<ParamsCheckVO> checkWxjgParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本期结算金额
        BigDecimal targetMny;//专项费
        BigDecimal totalMny = mny;//累计本期结算金额  默认赋值本次

        //1.查询目标成本 现场施工费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标本期结算金额信息失败！");
        }

        // 未编制目标成本或目标成本中没有该产品的制作费时不管控；
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.外协加工费.getCode())) {
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.外协加工费.getCode());

        //2.查询累计
        List<SjCostReportVO> queryDataList = settleMapper.getWxjgMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)) {
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(WXJG_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-产品外协加工费】管控【产品实际外协加工费】 " + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("【产品】外协加工费超额预警");
                        paramsCheckDsVO.setWarnName("产品外协加工费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计外协加工费结算金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本外协加工费金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkCpcgParams(SettleVO vo) {

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkCpcgParamsByMny(vo));//单据管控-【目标成本-产品外购产品费】管控【产品实际外购产品费】

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;

    }
    private List<ParamsCheckVO> checkCpcgParamsByMny(SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getSettleTaxMny();//本期结算金额
        BigDecimal targetMny;//专项费
        BigDecimal totalMny = mny;//累计本期结算金额  默认赋值本次

        //1.查询目标成本 现场施工费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("获取目标本期结算金额信息失败！");
        }

        // 未编制目标成本或目标成本中没有该产品的制作费时不管控；
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.外购产品费.getCode())) {
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.外购产品费.getCode());

        //2.查询累计
        List<SjCostReportVO> queryDataList = settleMapper.getCpcgMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)) {
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CPCG_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-产品外购产品费】管控【产品实际外购产品费】 " + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("【产品】外购产品费超额预警");
                        paramsCheckDsVO.setWarnName("产品外购产品费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "超出金额："+ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计外购产品费结算金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，目标成本外购产品金额：").append(targetMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }

}
