/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.bean.ProductDetailEntity;
import com.ejianc.business.jlcost.cost.bean.ProductEntity;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.mapper.ProductDetailMapper;
import com.ejianc.business.jlcost.cost.mapper.ProductMapper;
import com.ejianc.business.jlcost.cost.service.IProductService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.ProductDetailVO;
import com.ejianc.business.jlcost.cost.vo.ProductVO;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productService")
public class ProductServiceImpl
extends BaseServiceImpl<ProductMapper, ProductEntity>
implements IProductService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITargetService targetService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ProductMapper productMapper;
    @Autowired
    private ProductDetailMapper detailMapper;
    private static final String CPZZF_MNY_PARAM_CODE = "P-jBXO0v0009";

    @Override
    public ParamsCheckVO checkParams(ProductVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(ProductVO vo) {
        List<Long> productIdsList;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List list = vo.getProductDetailList();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        ArrayList<Long> productIds = new ArrayList<Long>();
        BigDecimal total = new BigDecimal(0);
        for (ProductDetailVO productDetailVO : list) {
            if ("del".equals(productDetailVO.getRowState())) continue;
            projectIds.add(productDetailVO.getProjectId());
            productIds.add(productDetailVO.getProductId());
            total = total.add(productDetailVO.getOtherMny());
        }
        BigDecimal totalMny = mny = total;
        List<Long> projectIdsList = projectIds.stream().distinct().collect(Collectors.toList());
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getMakeMnyByProjectIds(projectIdsList, productIdsList = productIds.stream().distinct().collect(Collectors.toList()));
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
        HashMap<String, BigDecimal> decimalHashMap = new HashMap<String, BigDecimal>();
        for (QueryTargetDataVO queryTargetDataVO : targetDataList) {
            if (map.containsKey(queryTargetDataVO.getCostType())) {
                BigDecimal bigDecimal = (BigDecimal)map.get(queryTargetDataVO.getCostType());
                bigDecimal = bigDecimal.add(queryTargetDataVO.getMny());
                map.put(queryTargetDataVO.getCostType(), bigDecimal);
            } else {
                map.put(queryTargetDataVO.getCostType(), queryTargetDataVO.getMny());
            }
            String key = String.valueOf(queryTargetDataVO.getProjectId() + queryTargetDataVO.getProductId());
            if (decimalHashMap.containsKey(key)) continue;
            decimalHashMap.put(key, queryTargetDataVO.getMny());
        }
        if (!map.containsKey(CostTypeEnum.\u5236\u4f5c\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = (BigDecimal)map.get(CostTypeEnum.\u5236\u4f5c\u8d39.getCode());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getDr, (Object)0)).in(ProductDetailEntity::getProjectId, projectIdsList)).in(ProductDetailEntity::getProductId, productIdsList);
        if (null != vo.getId() && 0L != vo.getId()) {
            wrapper.ne(ProductDetailEntity::getPId, (Object)vo.getId());
        }
        List detailEntities = this.detailMapper.selectList((Wrapper)wrapper);
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        for (ProductDetailEntity detailEntity : detailEntities) {
            BigDecimal bigDecimal;
            String key = String.valueOf(detailEntity.getProjectId() + detailEntity.getProductId());
            if (hashMap.containsKey(key)) {
                bigDecimal = (BigDecimal)hashMap.get(key);
                bigDecimal = bigDecimal.add(detailEntity.getOtherMny());
                hashMap.put(key, bigDecimal);
                continue;
            }
            bigDecimal = new BigDecimal(0);
            bigDecimal = ComputeUtil.safeAdd((BigDecimal)bigDecimal, (BigDecimal)detailEntity.getOtherMny());
            hashMap.put(key, bigDecimal);
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CPZZF_MNY_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u4ea7\u54c1\u5236\u4f5c\u8d39\u3011\u7ba1\u63a7\u3010\u4ea7\u54c1\u5b9e\u9645\u5236\u4f5c\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    for (ProductDetailVO productDetailVO : vo.getProductDetailList()) {
                        String key = String.valueOf(productDetailVO.getProjectId() + productDetailVO.getProductId());
                        BigDecimal targetCost = (BigDecimal)decimalHashMap.get(key);
                        BigDecimal targetCost1 = new BigDecimal(0);
                        if (null != targetCost) {
                            targetCost1 = targetCost;
                        }
                        String key1 = String.valueOf(productDetailVO.getProjectId() + productDetailVO.getProductId());
                        BigDecimal decimal1 = (BigDecimal)hashMap.get(key1);
                        BigDecimal historicalTotal = new BigDecimal(0);
                        historicalTotal = decimal1 == null ? productDetailVO.getOtherMny().add(BigDecimal.valueOf(0L)) : productDetailVO.getOtherMny().add(decimal1);
                        BigDecimal roleValue = datum.getRoleValue();
                        targetCost1 = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetCost1, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        if (historicalTotal.compareTo(targetCost1) <= 0) continue;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem(productDetailVO.getProjectName() + "-" + productDetailVO.getProductName() + "\u5236\u4f5c\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u4ea7\u54c1\u5236\u4f5c\u8d39\u8d85\u76ee\u6807\u6210\u672c\u4ea7\u54c1\u5236\u4f5c\u8d39");
                        StringBuffer stringBuffer = new StringBuffer();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + historicalTotal + "-" + targetCost1 + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)historicalTotal, (BigDecimal)targetCost1).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u5236\u4f5c\u8d39\u91d1\u989d\uff1a").append(historicalTotal.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5236\u4f5c\u8d39\u91d1\u989d\uff1a").append(targetCost1.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

