/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.CollectDetailEntity;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.mapper.CollectMapper;
import com.ejianc.business.jlcost.finance.service.ICollectDetailService;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.vo.CollectVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="collectService")
public class CollectServiceImpl
extends BaseServiceImpl<CollectMapper, CollectEntity>
implements ICollectService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ICollectDetailService collectDetailService;

    @Override
    public CollectVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CollectEntity::getContractId, (Object)contractId);
        queryWrapper.eq(CollectEntity::getProjectId, (Object)projectId);
        queryWrapper.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        CollectVO collectVO = new CollectVO();
        BigDecimal sumInvoiceMny = BigDecimal.ZERO;
        BigDecimal sumInvoiceTaxMny = BigDecimal.ZERO;
        for (CollectEntity entity : list) {
            sumInvoiceMny = ComputeUtil.safeAdd((BigDecimal)sumInvoiceMny, (BigDecimal)entity.getInvoiceMny());
            sumInvoiceTaxMny = ComputeUtil.safeAdd((BigDecimal)sumInvoiceTaxMny, (BigDecimal)entity.getInvoiceTaxMny());
        }
        collectVO.setSumInvoiceMny(sumInvoiceMny);
        collectVO.setSumInvoiceTaxMny(sumInvoiceTaxMny);
        return collectVO;
    }

    @Override
    public CollectVO contToCollect(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        CollectVO collectVO = (CollectVO)BeanMapper.map((Object)((Object)contractEntity), CollectVO.class);
        collectVO.setId(null);
        collectVO.setBillCode(null);
        collectVO.setCreateTime(null);
        collectVO.setCreateUserCode(null);
        collectVO.setUpdateTime(null);
        collectVO.setUpdateUserCode(null);
        collectVO.setMemo(null);
        collectVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        collectVO.setSignDate(new Date());
        collectVO.setContractType(String.valueOf(contractEntity.getContractType()));
        collectVO.setContractId(contractId);
        collectVO.setContractCode(contractEntity.getBillCode());
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            CollectVO result = this.querySumMny(contractId, contractEntity.getProjectId());
            collectVO.setSumInvoiceMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceTaxMny(result.getSumInvoiceTaxMny());
            collectVO.setSumInvoiceAllMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceAllTaxMny(result.getSumInvoiceTaxMny());
        }
        return collectVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId, boolean hasChildren) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List settleEntities = this.settleService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : settleEntities) {
                sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", (Object)sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", (Object)sumSettleTaxMny);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(CollectEntity::getContractId, (Object)contractId);
        query.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal sumInvoiceAllMny = BigDecimal.ZERO;
            BigDecimal sumInvoiceAllTaxMny = BigDecimal.ZERO;
            ArrayList<Long> idList = new ArrayList<Long>();
            for (CollectEntity entity : list) {
                sumInvoiceAllMny = ComputeUtil.safeAdd((BigDecimal)sumInvoiceAllMny, (BigDecimal)entity.getInvoiceMny());
                sumInvoiceAllTaxMny = ComputeUtil.safeAdd((BigDecimal)sumInvoiceAllTaxMny, (BigDecimal)entity.getInvoiceTaxMny());
                idList.add(entity.getId());
            }
            jsonObject.put("sumInvoiceAllMny", (Object)sumInvoiceAllMny);
            jsonObject.put("sumInvoiceAllTaxMny", (Object)sumInvoiceAllTaxMny);
            jsonObject.put("settledNoColtMny", (Object)ComputeUtil.safeSub((BigDecimal)jsonObject.getBigDecimal("sumSettleAllTaxMny"), (BigDecimal)sumInvoiceAllTaxMny));
            if (hasChildren) {
                LambdaQueryWrapper qry = new LambdaQueryWrapper();
                qry.in(CollectDetailEntity::getCollectId, idList);
                List detailEntities = this.collectDetailService.list((Wrapper)qry);
                if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
                    jsonObject.put("detailList", (Object)detailEntities);
                }
            }
        }
        return jsonObject;
    }
}

