package com.ejianc.business.jlcost.cost.service.impl;

import com.ejianc.business.jlcost.cost.bean.*;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetDetailService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("targetChange") 
public class TargetChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private ITargetChangeService changeService;

    @Autowired
	private ITargetService targetService;

	@Autowired
	private ITargetDetailService targetDetailService;
	@Autowired
	private ITargetRecordService recordService;
	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//变更表
		TargetChangeEntity changeEntity = changeService.selectById(billId);

		//主表
		TargetEntity targetEntity = targetService.selectById(changeEntity.getTargetId());

		//同步原数据到记录表
		TargetRecordEntity historyEntity = BeanMapper.map(targetEntity, TargetRecordEntity.class);
		historyEntity.setTargetId(changeEntity.getTargetId());//原合同主键
		historyEntity.setId(IdWorker.getId());
		recordService.saveOrUpdate(historyEntity, false);

		changeEntity.setEffectiveDate(new Date());
		changeService.saveOrUpdate(changeEntity, false);

		//回写合同主表
		targetEntity.setCostMny(changeEntity.getCostMny());//变更后金额变为变更前金额
		targetEntity.setPlanProfitMny(changeEntity.getPlanProfitMny());//变更后金额变为变更前金额
		targetEntity.setMaterialMny(changeEntity.getMaterialMny());//变更后金额变为变更前金额
		targetEntity.setLaborMny(changeEntity.getLaborMny());//变更后金额变为变更前金额
		targetEntity.setMakeMny(changeEntity.getMakeMny());//变更后金额变为变更前金额
		targetEntity.setSpecialMny(changeEntity.getSpecialMny());//变更后金额变为变更前金额
		targetEntity.setWxjgMny(changeEntity.getWxjgMny());//变更后金额变为变更前金额
		targetEntity.setWgcpMny(changeEntity.getWgcpMny());//变更后金额变为变更前金额
		targetEntity.setXcsgMny(changeEntity.getXcsgMny());//变更后金额变为变更前金额
		targetEntity.setXczzMny(changeEntity.getXczzMny());//变更后金额变为变更前金额
		targetEntity.setWbsjMny(changeEntity.getWbsjMny());//变更后金额变为变更前金额
		targetEntity.setTransportMny(changeEntity.getTransportMny());//变更后金额变为变更前金额
		targetEntity.setZtwbMny(changeEntity.getZtwbMny());//变更后金额变为变更前金额
		targetEntity.setOtherMny(changeEntity.getOtherMny());//变更后金额变为变更前金额

		targetEntity.setChangeStatus(3);//状态改为已变更

		targetEntity.setProjectId(changeEntity.getProjectId());
		targetEntity.setProjectName(changeEntity.getProjectName());
		targetEntity.setChangeReason(changeEntity.getChangeReason());


		//回写原合同清单表
		if (CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
			logger.info("复制子表开始--" + changeEntity.getDetailList());
			Map<Long, TargetDetailEntity> map = targetEntity.getDetailList().stream().collect(Collectors.toMap(TargetDetailEntity::getId, Function.identity(), (k1, k2) -> k2));
			List<Long> removeIds = targetEntity.getDetailList().stream().map(TargetDetailEntity::getId).collect(Collectors.toList());
			Map<Long, Long> detailIdMap = changeEntity.getDetailList().stream().filter(e -> null != e.getParentId()).collect(Collectors.toMap(TargetChangeDetailEntity::getId, TargetChangeDetailEntity::getSourceDetailId));
			changeEntity.getDetailList().forEach(vo -> {
				logger.info("复制子表--" + vo.getSourceDetailId());
				vo.setTargetId(targetEntity.getId());
				if (null != vo.getSourceDetailId()) {
					vo.setId(vo.getSourceDetailId());
					if (null != vo.getParentId()){
						vo.setParentId(map.get(vo.getSourceDetailId()).getParentId());
					}
					vo.setVersion(map.get(vo.getSourceDetailId()).getVersion());
					removeIds.remove(vo.getId());
				}else {
					if (null != vo.getParentId()){
						if (detailIdMap.containsKey(vo.getParentId())){
							vo.setParentId(detailIdMap.get(vo.getParentId()));
						}
					}
				}
			});
			if (CollectionUtils.isNotEmpty(removeIds)){
				targetDetailService.removeByIds(removeIds);
			}
			targetEntity.setDetailList(BeanMapper.mapList(changeEntity.getDetailList(), TargetDetailEntity.class));
		}
		targetDetailService.saveOrUpdateBatch(targetEntity.getDetailList(), targetEntity.getDetailList().size());
		boolean flag = targetService.saveOrUpdate(targetEntity);

		logger.info("业务逻辑完成--返回" + flag);
		if (flag) {
			//原合同附件复制到记录表
			//复制附件
			attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetEntity.getId()), "EJCBT202406000004", "attachMgr", String.valueOf(historyEntity.getId()), "EJCBT202406000006", "attachMgr");

			//变更合同附件复制到主合同
			attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), "EJCBT202406000005", "attachMgr", String.valueOf(targetEntity.getId()), "EJCBT202406000004", "attachMgr");

			return CommonResponse.success();
		} else {
			return CommonResponse.error("审批回写异常!");
		}

	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("该单据不可撤回！");
	}
}
