/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.ejianc.business.jlcost.cost.bean.TargetChangeDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.bean.TargetRecordEntity;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetDetailService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetChange")
public class TargetChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITargetChangeService changeService;
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetDetailService targetDetailService;
    @Autowired
    private ITargetRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TargetChangeEntity changeEntity = (TargetChangeEntity)((Object)this.changeService.selectById(billId));
        TargetEntity targetEntity = (TargetEntity)((Object)this.targetService.selectById(changeEntity.getTargetId()));
        TargetRecordEntity historyEntity = (TargetRecordEntity)((Object)BeanMapper.map((Object)((Object)targetEntity), TargetRecordEntity.class));
        historyEntity.setTargetId(changeEntity.getTargetId());
        historyEntity.setId(IdWorker.getId());
        this.recordService.saveOrUpdate((Object)historyEntity, false);
        changeEntity.setEffectiveDate(new Date());
        this.changeService.saveOrUpdate((Object)changeEntity, false);
        targetEntity.setCostMny(changeEntity.getCostMny());
        targetEntity.setPlanProfitMny(changeEntity.getPlanProfitMny());
        targetEntity.setMaterialMny(changeEntity.getMaterialMny());
        targetEntity.setLaborMny(changeEntity.getLaborMny());
        targetEntity.setMakeMny(changeEntity.getMakeMny());
        targetEntity.setSpecialMny(changeEntity.getSpecialMny());
        targetEntity.setWxjgMny(changeEntity.getWxjgMny());
        targetEntity.setWgcpMny(changeEntity.getWgcpMny());
        targetEntity.setXcsgMny(changeEntity.getXcsgMny());
        targetEntity.setXczzMny(changeEntity.getXczzMny());
        targetEntity.setWbsjMny(changeEntity.getWbsjMny());
        targetEntity.setTransportMny(changeEntity.getTransportMny());
        targetEntity.setZtwbMny(changeEntity.getZtwbMny());
        targetEntity.setOtherMny(changeEntity.getOtherMny());
        targetEntity.setChangeStatus(3);
        targetEntity.setProjectId(changeEntity.getProjectId());
        targetEntity.setProjectName(changeEntity.getProjectName());
        targetEntity.setChangeReason(changeEntity.getChangeReason());
        if (CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getDetailList());
            Map map = targetEntity.getDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (k1, k2) -> k2));
            List removeIds = targetEntity.getDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<Long, Long> detailIdMap = changeEntity.getDetailList().stream().filter(e -> null != e.getParentId()).collect(Collectors.toMap(BaseEntity::getId, TargetChangeDetailEntity::getSourceDetailId));
            changeEntity.getDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getSourceDetailId());
                vo.setTargetId(targetEntity.getId());
                if (null != vo.getSourceDetailId()) {
                    vo.setId(vo.getSourceDetailId());
                    if (null != vo.getParentId()) {
                        vo.setParentId(((TargetDetailEntity)((Object)((Object)map.get(vo.getSourceDetailId())))).getParentId());
                    }
                    vo.setVersion(((TargetDetailEntity)((Object)((Object)map.get(vo.getSourceDetailId())))).getVersion());
                    removeIds.remove(vo.getId());
                } else if (null != vo.getParentId() && detailIdMap.containsKey(vo.getParentId())) {
                    vo.setParentId((Long)detailIdMap.get(vo.getParentId()));
                }
            });
            if (CollectionUtils.isNotEmpty(removeIds)) {
                this.targetDetailService.removeByIds(removeIds);
            }
            targetEntity.setDetailList(BeanMapper.mapList(changeEntity.getDetailList(), TargetDetailEntity.class));
        }
        this.targetDetailService.saveOrUpdateBatch(targetEntity.getDetailList(), targetEntity.getDetailList().size());
        boolean flag = this.targetService.saveOrUpdate((Object)targetEntity);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetEntity.getId()), "EJCBT202406000004", "attachMgr", String.valueOf(historyEntity.getId()), "EJCBT202406000006", "attachMgr");
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), "EJCBT202406000005", "attachMgr", String.valueOf(targetEntity.getId()), "EJCBT202406000004", "attachMgr");
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u53ef\u64a4\u56de\uff01");
    }
}

