/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.vo.ProjectRecordVO;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.enums.ChangeTypeEnum;
import com.ejianc.business.jlcost.payout.enums.PayoutTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.ContractMapper;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;
import com.ejianc.business.jlcost.payout.service.IContractDetailService;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractDetailVO;
import com.ejianc.business.jlcost.payout.vo.ContractVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WXJG_BILL_CODE = "WXJG_BILL_CODE";
    private static final String CPCG_BILL_CODE = "CPCG_BILL_CODE";
    private static final String ZTWB_BILL_CODE = "ZTWB_BILL_CODE";
    private static final String CDZL_BILL_CODE = "CDZL_BILL_CODE";
    private static final String WBJC_BILL_CODE = "WBJC_BILL_CODE";
    private static final String WBSJ_BILL_CODE = "WBSJ_BILL_CODE";
    private static final String WBRZ_BILL_CODE = "WBRZ_BILL_CODE";
    private static final String LWFB_BILL_CODE = "LWFB_BILL_CODE";
    private static final String CLCG_BILL_CODE = "CLCG_BILL_CODE";
    private static final String SBZL_BILL_CODE = "SBZL_BILL_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractChangeService contractChangeService;

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        if (StringUtils.isEmpty((String)contractVo.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(contractVo));
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(ContractEntity::getContractType, (Object)contractVo.getContractType());
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_type", new Parameter("eq", (Object)contractVo.getContractType()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getContractType, (Object)contractVo.getContractType());
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("contract_type", new Parameter("eq", (Object)contractVo.getContractType()));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseTaxMny(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeTaxMny(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class));
    }

    private String getContractBillCode(ContractVO contractVo) {
        String billCodeStr = "";
        if (PayoutTypeEnum.\u5916\u534f\u52a0\u5de5.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WXJG_BILL_CODE;
        } else if (PayoutTypeEnum.\u6210\u54c1\u91c7\u8d2d.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CPCG_BILL_CODE;
        } else if (PayoutTypeEnum.\u6574\u4f53\u5916\u5305.getCode().equals(contractVo.getContractType())) {
            billCodeStr = ZTWB_BILL_CODE;
        } else if (PayoutTypeEnum.\u573a\u5730\u6216\u8bbe\u5907\u79df\u8d41.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CDZL_BILL_CODE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u68c0\u6d4b.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBJC_BILL_CODE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u8bbe\u8ba1.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBSJ_BILL_CODE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u4ea7\u54c1\u8ba4\u8bc1.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBRZ_BILL_CODE;
        } else if (PayoutTypeEnum.\u52b3\u52a1\u5206\u5305.getCode().equals(contractVo.getContractType())) {
            billCodeStr = LWFB_BILL_CODE;
        } else if (PayoutTypeEnum.\u8bbe\u5907\u6216\u6750\u6599\u91c7\u8d2d.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CLCG_BILL_CODE;
        } else if (PayoutTypeEnum.\u8bbe\u5907\u79df\u8d41.getCode().equals(contractVo.getContractType())) {
            billCodeStr = SBZL_BILL_CODE;
        }
        BillCodeParam billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String contractBillCode = (String)billCode.getData();
        return contractBillCode;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)id));
        entity.setContractDetailList(null);
        ContractVO contractVo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)id);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public List<SjCostReportVO> querySjCostList(Page page, QueryWrapper wrapper) {
        return ((ContractMapper)this.baseMapper).querySjCostList(page, wrapper);
    }

    @Override
    public List<FinanceReportVO> queryFinanceList(Page page, QueryWrapper wrapper) {
        return ((ContractMapper)this.baseMapper).queryFinancecList(page, wrapper);
    }

    @Override
    public BigDecimal queryFinanceSum(Long projectId) {
        FinanceReportVO sumVO = ((ContractMapper)this.baseMapper).queryFinancecSum(projectId);
        if (sumVO == null) {
            return BigDecimal.ZERO;
        }
        if (sumVO.getReceiveMny() == null) {
            sumVO.setReceiveMny(BigDecimal.ZERO);
        }
        if (sumVO.getPaymentMny() == null) {
            sumVO.setPaymentMny(BigDecimal.ZERO);
        }
        return sumVO.getReceiveMny().subtract(sumVO.getPaymentMny());
    }

    @Override
    public List<SjCostReportVO> querySjDetailMny(Long projectId) {
        return ((ContractMapper)this.baseMapper).querySjDetailMny(projectId);
    }

    @Override
    public List<SjCostReportVO> queryMaterialMny(Long projectId) {
        return ((ContractMapper)this.baseMapper).queryMaterialMny(projectId);
    }

    @Override
    public List<SjCostReportVO> querySjCostMny(Long projectId) {
        return ((ContractMapper)this.baseMapper).querySjCostMny(projectId);
    }

    @Override
    public List<TargetMaterialDetailVO> queryMaterialSum(Long projectId, Long wbsId) {
        return ((ContractMapper)this.baseMapper).queryMaterialSum(projectId, wbsId);
    }

    @Override
    public List<TargetMaterialDetailVO> queryMaterialList(Page page, QueryWrapper wrapper, Long projectId, Long wbsId, Long materialId) {
        return ((ContractMapper)this.baseMapper).queryMaterialList(page, wrapper, projectId, wbsId, materialId);
    }

    @Override
    public BigDecimal queryWorkTime(Long projectId, Long wbsId) {
        TargetMaterialDetailVO vo = ((ContractMapper)this.baseMapper).querySjWorkTime(projectId, wbsId);
        if (null != vo) {
            return vo.getWorkTime();
        }
        return null;
    }

    @Override
    public List<TargetMaterialDetailVO> queryWorkTimeList(Page page, QueryWrapper wrapper, Long projectId, Long wbsId) {
        return ((ContractMapper)this.baseMapper).querySjWorkTimeList(page, wrapper, projectId, wbsId);
    }

    @Override
    public List<ProjectRecordVO> queryProjectList() {
        return ((ContractMapper)this.baseMapper).queryProjectList();
    }
}

