/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.finance.mapper.ReimburseMapper;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleSourceTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.SettleMapper;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private ITargetService targetService;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CPZX_MNY_PARAM_CODE = "P-7MAG850004";
    private static final String WXJG_MNY_PARAM_CODE = "P-4wl6550007";
    private static final String CPCG_MNY_PARAM_CODE = "P-Oy5o9U0008";
    private static final String WBSJF_MNY_PARAM_CODE = "P-onQ7dF0003";
    private static final String XCSGF_MNY_PARAM_CODE = "P-50GO4a0002";
    @Autowired
    private ReimburseMapper reimburseMapper;

    @Override
    public ParamsCheckVO checkWbsjParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkWbsjParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbsjParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u5916\u90e8\u8bbe\u8ba1\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u5916\u90e8\u8bbe\u8ba1\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.settleMapper.getWbsjMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(WBSJF_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u5916\u90e8\u8bbe\u8ba1\u8d39\u3011\u7ba1\u63a7\u3010\u5b9e\u9645\u5916\u90e8\u8bbe\u8ba1\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5916\u90e8\u8bbe\u8ba1\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u9879\u76ee\u5916\u90e8\u8bbe\u8ba1\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u5916\u90e8\u8bbe\u8ba1\u8d39\u91d1\u989d\uff1a").append(totalMnyStr).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5916\u90e8\u8bbe\u8ba1\u8d39\u91d1\u989d\uff1a").append(targetMnyStr).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public SettleVO contToSettle(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)contractEntity), SettleVO.class);
        settleVO.setId(null);
        settleVO.setBillCode(null);
        settleVO.setCreateTime(null);
        settleVO.setCreateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setMemo(null);
        settleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        settleVO.setSettleDate(new Date());
        settleVO.setSettleBillType(contractEntity.getContractType());
        settleVO.setContractId(contractId);
        settleVO.setContractCode(contractEntity.getBillCode());
        settleVO.setContractTaxRate(contractEntity.getTaxRate());
        settleVO.setSettleType(Integer.valueOf(1));
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            SettleVO result = this.querySumMny(contractId, contractEntity.getProjectId());
            settleVO.setSumSettleMny(result.getSumSettleMny());
            settleVO.setSumSettleTaxMny(result.getSumSettleTaxMny());
            settleVO.setSumSettleAllMny(result.getSumSettleMny());
            settleVO.setSumSettleAllTaxMny(result.getSumSettleTaxMny());
        }
        ArrayList<SettleDetailVO> detailList = new ArrayList<SettleDetailVO>();
        for (ContractDetailEntity detailEntity : contractEntity.getContractDetailList()) {
            SettleDetailVO detailVO = (SettleDetailVO)BeanMapper.map((Object)((Object)detailEntity), SettleDetailVO.class);
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            detailVO.setCreateTime(null);
            detailVO.setCreateUserCode(null);
            detailVO.setUpdateTime(null);
            detailVO.setUpdateUserCode(null);
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setNum(null);
            detailVO.setPrice(detailEntity.getDetailPrice());
            detailVO.setTaxPrice(detailEntity.getDetailTaxPrice());
            detailVO.setTaxRate(contractEntity.getTaxRate());
            detailVO.setSourceId(String.valueOf(detailEntity.getId()));
            detailVO.setSourceType(String.valueOf(SettleSourceTypeEnum.\u5408\u540c\u6e05\u5355.getCode()));
            detailVO.setRowState("add");
            detailList.add(detailVO);
        }
        settleVO.setDetailList(detailList);
        return settleVO;
    }

    @Override
    public SettleVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.eq(SettleEntity::getProjectId, (Object)projectId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        SettleVO settleVO = new SettleVO();
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        for (SettleEntity entity : list) {
            sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)entity.getSettleMny());
            sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)entity.getSettleTaxMny());
        }
        settleVO.setSumSettleMny(sumSettleMny);
        settleVO.setSumSettleTaxMny(sumSettleTaxMny);
        return settleVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : list) {
                sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", (Object)sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", (Object)sumSettleTaxMny);
            jsonObject.put("settleTaxScale", (Object)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()), (BigDecimal)BigDecimal.valueOf(100L)));
            jsonObject.put("detailList", (Object)settleVOS);
        }
        return jsonObject;
    }

    @Override
    public ParamsCheckVO checkLwfbSbclSbzlParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkXcsgParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkXcsgParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u8d39\u7528\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u73b0\u573a\u65bd\u5de5\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u73b0\u573a\u65bd\u5de5\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.reimburseMapper.getMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(XCSGF_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u73b0\u573a\u65bd\u5de5\u8d39\u3011\u7ba1\u63a7\u3010\u5b9e\u9645\u73b0\u573a\u65bd\u5de5\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u73b0\u573a\u65bd\u5de5\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u9879\u76ee\u73b0\u573a\u65bd\u5de5\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u73b0\u573a\u65bd\u5de5\u8d39\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u73b0\u573a\u65bd\u5de5\u8d39\u91d1\u989d\uff1a").append(targetMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWbjcParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkWbjcParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbjcParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal certifiedMny;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u4e13\u9879\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u4e13\u9879\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.settleMapper.getWbjcMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if (null != (certifiedMny = this.settleMapper.selectCertifiedMny(vo.getProjectId(), vo.getProductId()))) {
            totalMny = totalMny.add(certifiedMny);
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CPZX_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u4ea7\u54c1\u4e13\u9879\u8d39\u3011\u7ba1\u63a7\u3010\u4ea7\u54c1\u5b9e\u9645\u4e13\u9879\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem(vo.getProductName() + "\u4e13\u9879\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u4ea7\u54c1\u4e13\u9879\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u4e13\u9879\u8d39\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u4e13\u9879\u8d39\u91d1\u989d\uff1a").append(targetMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWbcpParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkWbcpParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWbcpParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal detectionMny;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u4e13\u9879\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u4e13\u9879\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.settleMapper.getWbcpMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if (null != (detectionMny = this.settleMapper.selectDetectionMny(vo.getProjectId(), vo.getProductId()))) {
            totalMny = totalMny.add(detectionMny);
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CPZX_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u4ea7\u54c1\u4e13\u9879\u8d39\u3011\u7ba1\u63a7\u3010\u4ea7\u54c1\u5b9e\u9645\u4e13\u9879\u8d39\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem(vo.getProductName() + "\u4e13\u9879\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u4ea7\u54c1\u4e13\u9879\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u4e13\u9879\u8d39\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u4e13\u9879\u8d39\u91d1\u989d\uff1a").append(targetMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkWxjgParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkWxjgParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkWxjgParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u5916\u534f\u52a0\u5de5\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u5916\u534f\u52a0\u5de5\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.settleMapper.getWxjgMnyByProjectId(vo.getProjectId(), vo.getProductId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(WXJG_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u4ea7\u54c1\u5916\u534f\u52a0\u5de5\u8d39\u3011\u7ba1\u63a7\u3010\u4ea7\u54c1\u5b9e\u9645\u5916\u534f\u52a0\u5de5\u8d39\u3011 " + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem(vo.getProductName() + "\u5916\u534f\u52a0\u5de5\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u4ea7\u54c1\u5916\u534f\u52a0\u5de5\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u5916\u534f\u52a0\u5de5\u8d39\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5916\u534f\u52a0\u5de5\u8d39\u91d1\u989d\uff1a").append(targetMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkCpcgParams(SettleVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkCpcgParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkCpcgParamsByMny(SettleVO vo) {
        CommonResponse billParamByCode;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMny = mny = vo.getSettleTaxMny();
        CommonResponse<List<QueryTargetDataVO>> targetData = this.targetService.getTargetDataByProductId(vo.getProjectId(), vo.getProductId());
        if (!targetData.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List targetDataList = (List)targetData.getData();
        if (CollectionUtils.isEmpty((Collection)targetDataList)) {
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.\u5916\u8d2d\u4ea7\u54c1\u8d39.getCode())) {
            return paramsCheckVOS;
        }
        BigDecimal targetMny = targetMap.get(CostTypeEnum.\u5916\u8d2d\u4ea7\u54c1\u8d39.getCode());
        List<SjCostReportVO> queryDataList = this.settleMapper.getCpcgMnyByProjectId(vo.getProjectId(), vo.getProductId());
        if (CollectionUtils.isNotEmpty(queryDataList)) {
            for (SjCostReportVO reportVO : queryDataList) {
                if (null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)reportVO.getMny());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CPCG_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u76ee\u6807\u6210\u672c-\u4ea7\u54c1\u5916\u8d2d\u4ea7\u54c1\u8d39\u3011\u7ba1\u63a7\u3010\u4ea7\u54c1\u5b9e\u9645\u5916\u8d2d\u4ea7\u54c1\u8d39\u3011 " + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem(vo.getProductName() + "\u5916\u8d2d\u4ea7\u54c1\u8d39\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u4ea7\u54c1\u5916\u8d2d\u4ea7\u54c1\u8d39\u8d85\u76ee\u6807\u6210\u672c");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, 4).toString();
                        String targetMnyStr = targetMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u7d2f\u8ba1\u5916\u8d2d\u4ea7\u54c1\u8d39\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u5916\u8d2d\u4ea7\u54c1\u91d1\u989d\uff1a").append(targetMny.setScale(2, 4)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

