package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetDetailService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.*;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 成本管理-成本相关报表
 *
 * @author generator
 */
@Controller
@RequestMapping("costReport")
public class CostReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private ITargetService targetService;

    @Autowired
    private ITargetDetailService targetDetailService;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Autowired
    private TargetMapper targetMapper;


    /**
     * @param param
     * @Description queryList 实际成本台账查询
     * @Return
     */
    @RequestMapping(value = "/queryCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCost(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");

        Page<SjCostReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<SjCostReportVO> RecordVOList = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            RecordVOList = contractService.querySjCostList(page, wrapper);
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelCost", method = RequestMethod.POST)
    @ResponseBody
    public void excelCost(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");

        Page<SjCostReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<SjCostReportVO> list = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = contractService.querySjCostList(page, wrapper);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }


    /**
     * @param param
     * @Description queryList 项目虚拟资金账户统计
     * @Return
     */
    @RequestMapping(value = "/queryFinance", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryFinancec(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");

        Page<FinanceReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<FinanceReportVO> RecordVOList = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            RecordVOList = contractService.queryFinanceList(page, wrapper);
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelFinance", method = RequestMethod.POST)
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");

        Page<FinanceReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<FinanceReportVO> list = new ArrayList<>();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            list = contractService.queryFinanceList(page, wrapper);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("financeReport-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/getFinanceMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getFinanceMny(Long projectId) {
        return CommonResponse.success(contractService.queryFinanceSum(projectId));
    }

    /**
     * @param projectId
     * @Description 目标成本执行情况
     */
    @RequestMapping(value = "/queryTargetReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TargetReportVO> queryTargetReport(Long projectId) {
        TargetReportVO vo = new TargetReportVO();

        //第一步  获取目标成本，实际成本信息
        LambdaQueryWrapper<TargetEntity> lambda = Wrappers.<TargetEntity>lambdaQuery();
        lambda.eq(TargetEntity::getProjectId, projectId);
        lambda.in(TargetEntity::getBillState, 1, 3);
        List<TargetEntity> targetEntityList = targetService.list(lambda);
        if (CollectionUtils.isNotEmpty(targetEntityList)) {
            TargetEntity targetEntity = targetEntityList.get(0);
            //获取实际成本信息   获取实际成本  +  材料费用(按照材料+构件id分组  单独出)
            List<SjCostReportVO> sjList = contractService.querySjDetailMny(projectId);
            List<SjCostReportVO> materialList = contractService.queryMaterialMny(projectId);
            Map<Long,Map<Integer, BigDecimal>> map = new HashMap<>();
            Map<Long, BigDecimal> materialMap = new HashMap<>();
            BigDecimal sjCostMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(sjList)) {
                Long wbsId = null;
                for (SjCostReportVO sjvo : sjList) {
                    if(null!=sjvo.getWbsId()){
                        wbsId = sjvo.getWbsId();
                        //有产品id

                    }else{
                        //没有产品id
                        wbsId = 99L;
                    }

                    if(map.containsKey(wbsId)){
                        Map<Integer, BigDecimal> map1 = map.get(wbsId);
                        map1.put(sjvo.getCostType(), sjvo.getMny());
                        map.put(wbsId,map1);
                    }else{
                        Map<Integer, BigDecimal> map1 = new HashMap<>();
                        map1.put(sjvo.getCostType(), sjvo.getMny());
                        map.put(wbsId,map1);
                    }

                }
            }
            if (CollectionUtils.isNotEmpty(materialList)) {
                for (SjCostReportVO sjvo : materialList) {
                    if (materialMap.containsKey(sjvo.getWbsId())) {
                        BigDecimal materialCostMny = ComputeUtil.safeAdd(materialMap.get(sjvo.getWbsId()), sjvo.getMny());
                        materialMap.put(sjvo.getWbsId(), materialCostMny);
                    } else {
                        materialMap.put(sjvo.getWbsId(), sjvo.getMny());
                    }
                }
            }
            //  第二步，填充表头信息
            vo.setProjectId(projectId);
            vo.setProjectCode(targetEntity.getProjectCode());
            vo.setProjectName(targetEntity.getProjectName());
            //获取最新的合同金额
            TargetVO targetVO = targetMapper.queryContractTaxMnyByProjectId(projectId);
            vo.setContractMny(targetVO.getContractMny());
            vo.setContractTaxMny(targetVO.getContractTaxMny());
            vo.setCostMny(targetEntity.getCostMny());
            vo.setPlanProfitMny(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getCostMny()));

            //第三步，获取目标成本明细

            LambdaQueryWrapper<TargetDetailEntity> lambdab = Wrappers.<TargetDetailEntity>lambdaQuery();
            lambdab.eq(TargetDetailEntity::getTargetId, targetEntity.getId());
//            lambdab.ne(TargetDetailEntity::getRowType, 7);//默认筛选出来 前三层有效数据
            List<TargetDetailEntity> targetDetailEntities = targetDetailService.list(lambdab);
            Map<Long, TargetDetailEntity> idMap = targetDetailEntities.stream().collect(Collectors.toMap(TargetDetailEntity::getId, x -> x));
            //第四步，合并 目标成本+实际成本  生成目标成本执行情况
            if (CollectionUtils.isNotEmpty(targetDetailEntities)) {
                List<TargetReportDetailVO> resList = new ArrayList<>();
                Set<Long> set = new HashSet<>(); // 根据wbsId拼装材料费，
                Map<Long, BigDecimal> mbMap = new HashMap<>();
                Map<Long, TargetReportDetailVO> detailMap = new HashMap<>();
                List<TargetReportDetailVO> list = BeanMapper.mapList(targetDetailEntities, TargetReportDetailVO.class);
                //先把材料费累加一下目标成本金额
                if (CollectionUtils.isNotEmpty(list)) {
                    for (TargetReportDetailVO detailVO : list) {
                        if (null != detailVO.getRowType() && 5 == detailVO.getRowType()) {
                            Long wbsId = idMap.get(detailVO.getParentId()).getSourceId();//材料费用上级一定是 零件id
                            if (null != detailVO.getCostType() && 0 == detailVO.getCostType()) {
                                if (mbMap.containsKey(wbsId)) {
                                    BigDecimal materialCostMny = ComputeUtil.safeAdd(mbMap.get(wbsId), detailVO.getMny());
                                    mbMap.put(wbsId, materialCostMny);
                                } else {
                                    mbMap.put(wbsId, detailVO.getMny());
                                }
                            }
                        }
                        detailMap.put(detailVO.getId(),detailVO);
                    }
                }
                list.forEach(e -> {
                    if (null != e.getCostType() && 0 != e.getCostType()) {
                        Long wbsId = null;
                        if(2 == e.getRowLevel() && (2 == e.getCostType()||3 == e.getCostType()||4 == e.getCostType()||5 == e.getCostType())){
                            wbsId = detailMap.get(e.getParentId()).getSourceId();
                        }else{
                            wbsId = 99L;
                        }
                        e.setSjCostMny(map.get(wbsId).get(e.getCostType()));
                        resList.add(e);
                    } else if (null != e.getCostType() && 0 == e.getCostType()) {
                        //如果是材料费，需合并后增加一行材料费的新数据，根据上级的wbsid 取实际成本金额
                        Long wbsId = idMap.get(e.getParentId()).getSourceId();//材料费用上级一定是 零件id
                        if (!set.contains(wbsId)) {
                            TargetReportDetailVO detailVO = new TargetReportDetailVO();
                            detailVO.setId(wbsId + 99L);
                            detailVO.setCode(idMap.get(e.getParentId()).getCode() + "01");
                            detailVO.setName("材料费");
                            detailVO.setCostType(0);
                            detailVO.setRowLevel(3);
                            detailVO.setRowType(5);
                            detailVO.setSourceId(wbsId);//为了点击 查询材料情况 使用
                            detailVO.setMny(mbMap.get(wbsId));
                            detailVO.setSjCostMny(materialMap.get(wbsId));
                            detailVO.setParentId(e.getParentId());
                            resList.add(detailVO);
                            set.add(wbsId);
                        }
                    } else if (null == e.getCostType()) {
                        resList.add(e);
                    }
                });
                //汇总 2级 实际成本
                resList.forEach(e -> {
                    if (2 == e.getRowLevel()&&3==e.getRowType()) {
                        e.setSjCostMny(getCostMny(e, resList, 3));
                    }
                });
                //汇总 1级 实际成本
                resList.forEach(e -> {
                    if (1 == e.getRowLevel()&&1==e.getRowType()) {
                        e.setSjCostMny(getCostMny(e, resList, 2));
                    }
                });

                //汇总 1级 实际成本合计
                for (TargetReportDetailVO e : resList) {
                    if (1 == e.getRowLevel()) {
                        sjCostMny = ComputeUtil.safeAdd(sjCostMny, e.getSjCostMny());
                    }
                }
                vo.setSjCostMny(sjCostMny);
                vo.setSjProfitMny(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getSjCostMny()));
                vo.setDetailList(TreeNodeBUtil.buildTree(resList));
            }
            //第五步，生成费用类型汇总情况
            List<SjCostReportVO> costAllList = contractService.querySjCostMny(projectId);
            Map<Integer, BigDecimal> costMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(costAllList)) {
                for (SjCostReportVO sjvo : costAllList) {
                    costMap.put(sjvo.getCostType(), sjvo.getMny());
                }
            }
            vo.setCostList(getTargetReportCostVO(targetEntity, vo, costMap));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param projectId
     * @Description 明细执行情况 (材料)
     */
    @RequestMapping(value = "/queryMaterialSum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TargetMaterialDetailVO>> queryMaterialSum(Long projectId, Long wbsId) {
        return CommonResponse.success(contractService.queryMaterialSum(projectId, wbsId));
    }

//    /**
//     * @Description 材料出库详情
//     * @param projectId
//     */
//    @RequestMapping(value = "/queryMaterialList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<TargetMaterialDetailVO>> queryMaterialList(Long projectId, Long wbsId,Long materialId) {
//        return CommonResponse.success(contractService.queryMaterialList(projectId,wbsId,materialId));
//    }

    /**
     * @param param
     * @Description queryList 材料出库详情
     * @Return
     */
    @RequestMapping(value = "/queryMaterialList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryMaterialList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("code");
        fuzzyFields.add("spec");
        fuzzyFields.add("name");
        Page<TargetMaterialDetailVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<TargetMaterialDetailVO> RecordVOList = new ArrayList<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Long projectId = Long.valueOf(String.valueOf(param.getParams().get("projectId").getValue()));
        Long wbsId = Long.valueOf(String.valueOf(param.getParams().get("wbsId").getValue()));
        Long materialId = Long.valueOf(String.valueOf(param.getParams().get("materialId").getValue()));
        RecordVOList = contractService.queryMaterialList(page, wrapper, projectId, wbsId, materialId);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param projectId
     * @Description 明细执行情况（人工工时）
     */
    @RequestMapping(value = "/queryWorkTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryWorkTime(Long projectId, Long wbsId) {
        return CommonResponse.success(contractService.queryWorkTime(projectId, wbsId));
    }

//    /**
//     * @Description 工时结算详情
//     * @param projectId
//     */
//    @RequestMapping(value = "/queryWorkTimeList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<TargetMaterialDetailVO>> queryWorkTimeList(Long projectId, Long wbsId) {
//        return CommonResponse.success(contractService.queryWorkTimeList(projectId,wbsId));
//    }

    /**
     * @param param
     * @Description queryList 工时结算详情
     * @Return
     */
    @RequestMapping(value = "/queryWorkTimeList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryWorkTimeList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        Page<TargetMaterialDetailVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<TargetMaterialDetailVO> RecordVOList = new ArrayList<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Long projectId = Long.valueOf(String.valueOf(param.getParams().get("projectId").getValue()));
        Long wbsId = Long.valueOf(String.valueOf(param.getParams().get("wbsId").getValue()));
        RecordVOList = contractService.queryWorkTimeList(page, wrapper, projectId, wbsId);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", RecordVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    public List<TargetReportCostVO> getTargetReportCostVO(TargetEntity targetEntity, TargetReportVO vo, Map<Integer, BigDecimal> costMap) {
        List<TargetReportCostVO> costList = new ArrayList<>();
        TargetReportCostVO targetReportCostVO = BeanMapper.map(targetEntity, TargetReportCostVO.class);
        targetReportCostVO.setId(1L);
        targetReportCostVO.setName("目标成本");
        targetReportCostVO.setCostMny(vo.getCostMny());
        costList.add(targetReportCostVO);

        TargetReportCostVO targetReportCostVO2 = new TargetReportCostVO();
        targetReportCostVO2.setId(2L);
        targetReportCostVO2.setName("实际成本");
        targetReportCostVO2.setCostMny(vo.getSjCostMny());
        if (null != costMap) {
            targetReportCostVO2.setMaterialMny(costMap.get(0));
            targetReportCostVO2.setLaborMny(costMap.get(1));
            targetReportCostVO2.setMakeMny(costMap.get(2));
            targetReportCostVO2.setSpecialMny(costMap.get(3));
            targetReportCostVO2.setWxjgMny(costMap.get(4));
            targetReportCostVO2.setWgcpMny(costMap.get(5));
            targetReportCostVO2.setXcsgMny(costMap.get(6));
            targetReportCostVO2.setXczzMny(costMap.get(7));
            targetReportCostVO2.setWbsjMny(costMap.get(8));
            targetReportCostVO2.setTransportMny(costMap.get(9));
            targetReportCostVO2.setZtwbMny(costMap.get(10));
            targetReportCostVO2.setOtherMny(costMap.get(11));
        }
        costList.add(targetReportCostVO2);

        TargetReportCostVO targetReportCostVO3 = new TargetReportCostVO();
        targetReportCostVO3.setId(3L);
        targetReportCostVO3.setName("目标-实际");
        targetReportCostVO3.setCostMny(ComputeUtil.safeSub(targetReportCostVO.getCostMny(), targetReportCostVO2.getCostMny()));
        targetReportCostVO3.setMaterialMny(ComputeUtil.safeSub(targetReportCostVO.getMaterialMny(), targetReportCostVO2.getMaterialMny()));
        targetReportCostVO3.setLaborMny(ComputeUtil.safeSub(targetReportCostVO.getLaborMny(), targetReportCostVO2.getLaborMny()));
        targetReportCostVO3.setMakeMny(ComputeUtil.safeSub(targetReportCostVO.getMakeMny(), targetReportCostVO2.getMakeMny()));
        targetReportCostVO3.setSpecialMny(ComputeUtil.safeSub(targetReportCostVO.getSpecialMny(), targetReportCostVO2.getSpecialMny()));
        targetReportCostVO3.setWxjgMny(ComputeUtil.safeSub(targetReportCostVO.getWxjgMny(), targetReportCostVO2.getWxjgMny()));
        targetReportCostVO3.setWgcpMny(ComputeUtil.safeSub(targetReportCostVO.getWgcpMny(), targetReportCostVO2.getWgcpMny()));
        targetReportCostVO3.setXcsgMny(ComputeUtil.safeSub(targetReportCostVO.getXcsgMny(), targetReportCostVO2.getXcsgMny()));
        targetReportCostVO3.setXczzMny(ComputeUtil.safeSub(targetReportCostVO.getXczzMny(), targetReportCostVO2.getXczzMny()));
        targetReportCostVO3.setWbsjMny(ComputeUtil.safeSub(targetReportCostVO.getWbsjMny(), targetReportCostVO2.getWbsjMny()));
        targetReportCostVO3.setTransportMny(ComputeUtil.safeSub(targetReportCostVO.getTransportMny(), targetReportCostVO2.getTransportMny()));
        targetReportCostVO3.setZtwbMny(ComputeUtil.safeSub(targetReportCostVO.getZtwbMny(), targetReportCostVO2.getZtwbMny()));
        targetReportCostVO3.setOtherMny(ComputeUtil.safeSub(targetReportCostVO.getOtherMny(), targetReportCostVO2.getOtherMny()));
        costList.add(targetReportCostVO3);

        return costList;
    }

    public BigDecimal getCostMny(TargetReportDetailVO vo, List<TargetReportDetailVO> list, int rowType) {
        BigDecimal costMny = BigDecimal.ZERO;
        for (TargetReportDetailVO e : list) {
            if (null != e.getRowLevel() && rowType == e.getRowLevel() && e.getParentId().equals(vo.getId())) {
                costMny = ComputeUtil.safeAdd(costMny, e.getSjCostMny());
            }
        }
        return costMny;
    }

    /**
     * @param param
     * @Description queryList 项目利润分析
     * @Return
     */
    @RequestMapping(value = "/queryProjectList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectRecordVO>> queryProjectList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        //查询本下所有启用、在建的项目，按项目创建时间倒序排列；
        if (!param.getParams().containsKey("projectStatus")){
            param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 2, 3)));
        }
        if (param.getParams().containsKey("projectName")){
            param.getParams().put("name", new Parameter(QueryParam.LIKE, param.getParams().get("projectName").getValue()));
            param.getParams().remove("projectName");
        }
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> records = projectResponse.getData().getRecords();
        List<ProjectRecordVO> RecordVOList = new ArrayList<>();
        List<ProjectRecordVO> resList = new ArrayList<>();
        RecordVOList = contractService.queryProjectList();
        Map<String, ProjectRecordVO> map = new HashMap<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> {
                map.put(e.getProjectId() + "||" + e.getType(), e);
            });
        }
        if (CollectionUtils.isNotEmpty(records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectId(e.getId());
                projectRecordVO.setProjectStatus(Integer.parseInt(e.getProjectStatus()));
                projectRecordVO.setProjectName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setProjectDate(e.getProjectDate());
                if (map.containsKey(e.getId() + "||" + 1)) {
                    projectRecordVO.setContractTaxMny(map.get(e.getId() + "||" + 1) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 1).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 2)) {
                    projectRecordVO.setSettleTaxMny(map.get(e.getId() + "||" + 2) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 2).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 3)) {
                    projectRecordVO.setCostMny(map.get(e.getId() + "||" + 3) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 3).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 4)) {
                    projectRecordVO.setSjMny(map.get(e.getId() + "||" + 4) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 4).getMny());
                }
                projectRecordVO.setPlanProfitMny(ComputeUtil.safeSub(projectRecordVO.getContractTaxMny(), projectRecordVO.getCostMny()));
                projectRecordVO.setSjProfitMny(ComputeUtil.safeSub(projectRecordVO.getContractTaxMny(), projectRecordVO.getSjMny()));
                projectRecordVO.setPlanProfitScale(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(projectRecordVO.getPlanProfitMny(), BigDecimal.valueOf(100)), projectRecordVO.getContractTaxMny()));
                projectRecordVO.setSjProfitScale(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(projectRecordVO.getSjProfitMny(), BigDecimal.valueOf(100)), projectRecordVO.getContractTaxMny()));
                resList.add(projectRecordVO);
            });
        }
        IPage<ProjectRecordVO> pageData = new Page<>(projectResponse.getData().getCurrent(), projectResponse.getData().getSize(), projectResponse.getData().getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelProjectList", method = RequestMethod.POST)
    @ResponseBody
    public void excelProjectList(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        //查询本下所有启用、在建的项目，按项目创建时间倒序排列；
        param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1, 2, 3)));
        CommonResponse<Page<ProjectArchiveVO>> projectResponse = projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectArchiveVO> records = projectResponse.getData().getRecords();
        List<ProjectRecordVO> RecordVOList = new ArrayList<>();
        List<ProjectRecordVO> resList = new ArrayList<>();
        RecordVOList = contractService.queryProjectList();
        Map<String, ProjectRecordVO> map = new HashMap<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> {
                map.put(e.getProjectId() + "||" + e.getType(), e);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectId(e.getId());
                projectRecordVO.setProjectStatus(Integer.parseInt(e.getProjectStatus()));
                projectRecordVO.setProjectName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setProjectDate(e.getProjectDate());
                if (map.containsKey(e.getId() + "||" + 1)) {
                    projectRecordVO.setContractTaxMny(map.get(e.getId() + "||" + 1) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 1).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 2)) {
                    projectRecordVO.setSettleTaxMny(map.get(e.getId() + "||" + 2) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 2).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 3)) {
                    projectRecordVO.setCostMny(map.get(e.getId() + "||" + 3) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 3).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 4)) {
                    projectRecordVO.setSjMny(map.get(e.getId() + "||" + 4) == null ? BigDecimal.ZERO : map.get(e.getId() + "||" + 4).getMny());
                }
                projectRecordVO.setPlanProfitMny(ComputeUtil.safeSub(projectRecordVO.getContractTaxMny(), projectRecordVO.getCostMny()));
                projectRecordVO.setSjProfitMny(ComputeUtil.safeSub(projectRecordVO.getContractTaxMny(), projectRecordVO.getSjMny()));
                projectRecordVO.setPlanProfitScale(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(projectRecordVO.getPlanProfitMny(), BigDecimal.valueOf(100)), projectRecordVO.getContractTaxMny()));
                projectRecordVO.setSjProfitScale(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(projectRecordVO.getSjProfitMny(), BigDecimal.valueOf(100)), projectRecordVO.getContractTaxMny()));
                resList.add(projectRecordVO);
            });
        }
        //todo:字段翻译等等
        resList.forEach((vo) -> {
            Integer projectStatus = vo.getProjectStatus();
            if (projectStatus == 1) vo.setProjectStatusName("商机阶段");
            if (projectStatus == 2) vo.setProjectStatusName("投标阶段");
            if (projectStatus == 3) vo.setProjectStatusName("未中标");
            if (projectStatus == 4) vo.setProjectStatusName("已中标");
            if (projectStatus == 5) vo.setProjectStatusName("合同阶段");
            if (projectStatus == 6) vo.setProjectStatusName("生产阶段");
            if (projectStatus == 7) vo.setProjectStatusName("供货阶段");
            if (projectStatus == 8) vo.setProjectStatusName("结算阶段");
            if (projectStatus == 9) vo.setProjectStatusName("完工");
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("projectListReport-export.xlsx", beans, response);
    }

}
