package com.ejianc.business.jlcost.payout.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.vo.ReimburseVO;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleBillCodeEnum;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 支出结算-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("settle")
public class SettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISettleService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            BigDecimal settleMny = BigDecimal.ZERO;
            BigDecimal settleTaxMny = BigDecimal.ZERO;
            BigDecimal settleTax = BigDecimal.ZERO;

            for (SettleDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if (!"del".equals(detailVO.getRowState())) {
                    settleMny = ComputeUtil.safeAdd(settleMny, detailVO.getMny());
                    settleTaxMny = ComputeUtil.safeAdd(settleTaxMny, detailVO.getTaxMny());
                    settleTax = ComputeUtil.safeAdd(settleTax, detailVO.getTax());
                }
            }

            BigDecimal sumSettleAllMny = ComputeUtil.safeAdd(settleMny, saveOrUpdateVO.getSumSettleMny());
            BigDecimal sumSettleAllTaxMny = ComputeUtil.safeAdd(settleTaxMny, saveOrUpdateVO.getSumSettleTaxMny());

            saveOrUpdateVO.setSettleMny(settleMny);
            saveOrUpdateVO.setSettleTaxMny(settleTaxMny);
            saveOrUpdateVO.setSettleTax(settleTax);
            saveOrUpdateVO.setSumSettleAllMny(sumSettleAllMny);
            saveOrUpdateVO.setSumSettleAllTaxMny(sumSettleAllTaxMny);
        }
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), SettleEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.eq(SettleEntity::getContractId, saveOrUpdateVO.getContractId());
        queryWrapper.eq(SettleEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        SettleEntity settleEntity = service.getOne(queryWrapper, false);
        if (null != settleEntity) {
            throw new BusinessException("该合同在该项目上存在未完成的结算单【" + settleEntity.getBillCode() + "】,不可再次新增结算单！");
        }
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(SettleBillCodeEnum.getEnumByType(saveOrUpdateVO.getSettleBillType()).getBillCode(), InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = service.selectById(id);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        buildParam(param);
        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList 支出合同统计
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySettleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> querySettleList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        Long contractId = Long.valueOf(param.getParams().get("contractId").toString());
        param.getParams().remove("contractId");
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(param.getParams().get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        if ("5".equals(InvocationInfoProxy.getOrgType()) || param.getParams().containsKey("projectId")) {
            List<SettleVO> resList = new ArrayList<>();
            Page<SettleVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
            QueryWrapper wrapper = changeToQueryWrapper(param);
            if (null!=projectId) {
                resList = service.querySettleList(page, wrapper,contractId, projectId, null);
            } else {
                resList = service.querySettleList(page, wrapper, contractId,null, orgId);
            }

            IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(resList);
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            // 当前组织为组织
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
            List<SettleVO> resList = new ArrayList<>();
            Page<SettleVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
            QueryWrapper wrapper = changeToQueryWrapper(param);
            resList = service.querySettleOrgList(page, wrapper, contractId);
            IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(resList);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }

    private void buildParam(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SettleVO>> commonResponse = queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<SettleVO> records = commonResponse.getData().getRecords();
        records.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("Settle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/querySumMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySumMny(@RequestParam Long contractId, @RequestParam Long projectId) {
        return CommonResponse.success("查询累计金额成功！", service.querySumMny(contractId, projectId));
    }

    /**
     * @Description 合同生成结算
     * @Return void
     */
    @RequestMapping(value = "/contToSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> contToSettle(@RequestParam Long contractId) {
        return CommonResponse.success("合同生成结算成功！", service.contToSettle(contractId));
    }

    /**
     * @Description 合同查询结算
     * @Return void
     */
    @RequestMapping(value = "/queryRecordByContId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryRecordByContId(@RequestParam Long contractId) {
        return CommonResponse.success("合同查询结算成功！", service.queryRecordByContId(contractId));
    }

    /**
     * 单据管控-【目标成本-外部设计费】管控【实际外部设计费】
     * @param vo
     * @return
     */
    @RequestMapping(value = "/checkWbsjParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbsjParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkWbsjParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }

    /**
     * 单据管控-【目标成本-现场施工费】管控【实际现场施工费】
     * checkLwfbSbclSbzlParams 劳务分包结算、设备或材料采购结算、设备租赁结算
     * @param vo
     * @return
     */
    @RequestMapping(value = "/checkLwfbSbclSbzlParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkLwfbSbclSbzlParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkLwfbSbclSbzlParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }


    /**
     * 单据管控-【目标成本-产品专项费】管控【产品实际专项费】 外部检测结算
     * @param vo
     * @return
     */
    @PostMapping(value = "/checkWbjcParams")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbjcParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkWbjcParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }

    /**
     * 单据管控-【目标成本-产品专项费】管控【产品实际专项费】 外部产品认证结算
     * @param vo
     * @return
     */
    @PostMapping(value = "/checkWbcpParams")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbcpParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkWbcpParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }

    /**
     * 单据管控-【目标成本-产品外协加工费】管控【产品实际外协加工费】外协加工结算
     * @param vo
     * @return
     */
    @PostMapping(value = "/checkWxjgParams")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWxjgParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkWxjgParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }

    /**
     * 单据管控-【目标成本-产品外购产品费】管控【产品实际外购产品费】
     * @param vo
     * @return
     */
    @PostMapping(value = "/checkCpcgParams")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkCpcgParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkCpcgParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }


}
