package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.PaymentMapper;
import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.service.IPaymentService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 资金管理-付款单
 * 
 * @author generator
 * 
 */
@Service("paymentService")
public class PaymentServiceImpl extends BaseServiceImpl<PaymentMapper, PaymentEntity> implements IPaymentService{

    @Autowired
    private ISettleService settleService;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IReceiveService receiveService;

    @Override
    public PaymentVO addPaymentByConId(Long id) {
        PaymentVO paymentVO = new PaymentVO();
        ContractEntity entity = contractService.selectById(id);
        paymentVO.setContractId(entity.getId());
        paymentVO.setContractCode(entity.getBillCode());
        paymentVO.setContractName(entity.getContractName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setContractTaxMny(entity.getContractTaxMny());
        paymentVO.setCustomerId(entity.getCustomerId());
        paymentVO.setCustomerName(entity.getCustomerName());
        paymentVO.setSupplierId(entity.getSupplierId());
        paymentVO.setSupplierName(entity.getSupplierName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setDepartmentId(entity.getDepartmentId());
        paymentVO.setDepartmentName(entity.getDepartmentName());
        paymentVO.setOrgId(entity.getOrgId());
        paymentVO.setOrgName(entity.getOrgName());
        paymentVO.setOrgCode(entity.getOrgCode());
        paymentVO.setParentOrgId(entity.getParentOrgId());
        paymentVO.setParentOrgName(entity.getParentOrgName());
        paymentVO.setParentOrgCode(entity.getParentOrgCode());
        paymentVO.setProjectId(entity.getProjectId());
        paymentVO.setProjectName(entity.getProjectName());
        paymentVO.setProjectCode(entity.getProjectCode());
        paymentVO.setProjectType(entity.getProjectType());

        //计算付款单不含本期累计付款金额并赋值
        LambdaQueryWrapper<PaymentEntity> paymentLambda = new LambdaQueryWrapper<>();
        paymentLambda.eq(PaymentEntity::getContractId, id);
        paymentLambda.in(PaymentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        paymentLambda.orderByDesc(PaymentEntity::getPaymentDate);
        List<PaymentEntity> entities = super.list(paymentLambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setHistoryPaymentTaxMny(totalPaymentTaxMny);
            paymentVO.setTotalPaymentTaxMny(totalPaymentTaxMny);
        }else {
            paymentVO.setHistoryPaymentTaxMny(new BigDecimal(0));
            paymentVO.setTotalPaymentTaxMny(new BigDecimal(0));
        }

        //计算结算单累计结算金额并赋值
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, id);
        settleLambda.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        settleLambda.orderByDesc(SettleEntity::getSettleDate);
        List<SettleEntity> settleEntities = settleService.list(settleLambda);
        if (CollectionUtils.isNotEmpty(settleEntities)) {
            BigDecimal totalSettleTaxMny = settleEntities.stream().filter(item -> null != item.getSettleTaxMny()).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalSettleTaxMny(totalSettleTaxMny);
        }else {
            paymentVO.setTotalSettleTaxMny(new BigDecimal(0));
        }

        //计算收票登记累计收票金额并赋值
        LambdaQueryWrapper<CollectEntity> collectLambda = new LambdaQueryWrapper<>();
        collectLambda.eq(CollectEntity::getContractId, id);
        collectLambda.in(CollectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        collectLambda.orderByDesc(CollectEntity::getSignDate);
        List<CollectEntity> collectEntities = collectService.list(collectLambda);
        if (CollectionUtils.isNotEmpty(collectEntities)) {
            BigDecimal totalCollectTaxMny = collectEntities.stream().filter(item -> null != item.getInvoiceTaxMny()).map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalInvoiceTaxMny(totalCollectTaxMny);
        }else {
            paymentVO.setTotalInvoiceTaxMny(new BigDecimal(0));
        }

        return paymentVO;
    }

    @Override
    public PaymentVO addProjectTotalMny(Long id, Long projectId) {
        PaymentVO paymentVO = new PaymentVO();

        LambdaQueryWrapper<PaymentEntity> paymentLambda = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<CollectEntity> collectLambda = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<ReceiveEntity> receiveLambda = new LambdaQueryWrapper<>();

        //计算付款单不含本期累计付款金额并赋值
        paymentLambda.eq(PaymentEntity::getContractId, id);
        paymentLambda.eq(PaymentEntity::getProjectId, projectId);
        paymentLambda.in(PaymentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PaymentEntity> entities = super.list(paymentLambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setHistoryPaymentTaxMny(totalPaymentTaxMny);
            paymentVO.setTotalPaymentTaxMny(totalPaymentTaxMny);
        }else {
            paymentVO.setHistoryPaymentTaxMny(new BigDecimal(0));
            paymentVO.setTotalPaymentTaxMny(new BigDecimal(0));
        }

        //计算结算单累计结算金额并赋值
        settleLambda.eq(SettleEntity::getContractId, id);
        settleLambda.eq(SettleEntity::getProjectId, projectId);
        settleLambda.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> settleEntities = settleService.list(settleLambda);
        if (CollectionUtils.isNotEmpty(settleEntities)) {
            BigDecimal totalSettleTaxMny = settleEntities.stream().filter(item -> null != item.getSettleTaxMny()).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalSettleTaxMny(totalSettleTaxMny);
        }else {
            paymentVO.setTotalSettleTaxMny(new BigDecimal(0));
        }

        //计算收票登记累计收票金额并赋值
        collectLambda.eq(CollectEntity::getContractId, id);
        collectLambda.eq(CollectEntity::getProjectId, projectId);
        collectLambda.in(CollectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CollectEntity> collectEntities = collectService.list(collectLambda);
        if (CollectionUtils.isNotEmpty(collectEntities)) {
            BigDecimal totalCollectTaxMny = collectEntities.stream().filter(item -> null != item.getInvoiceTaxMny()).map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalInvoiceTaxMny(totalCollectTaxMny);
        }else {
            paymentVO.setTotalInvoiceTaxMny(new BigDecimal(0));
        }

        //查询该项目下收入合同累计收款金额
        receiveLambda.eq(ReceiveEntity::getProjectId, projectId);
        receiveLambda.in(ReceiveEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ReceiveEntity> receiveEntities = receiveService.list(receiveLambda);
        if (CollectionUtils.isNotEmpty(receiveEntities)) {
            BigDecimal totalReceiveTaxMny = receiveEntities.stream().filter(item -> null != item.getReceiveMny()).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setProjectTotalIncome(totalReceiveTaxMny);
        }else {
            paymentVO.setProjectTotalIncome(new BigDecimal(0));
        }
        return paymentVO;

    }

    @Override
    public PaymentRecordVO queryChangeRecord(Long id) {
        PaymentRecordVO paymentRecordVO = new PaymentRecordVO();
        JSONObject object = collectService.queryRecordByContId(id,false);
        BigDecimal totalSettleTaxMny = object.get("sumSettleAllTaxMny")==null?BigDecimal.ZERO:new BigDecimal(object.get("sumSettleAllTaxMny").toString()); // 累计结算金额
        BigDecimal totalInvoiceTaxMny = object.get("sumInvoiceAllTaxMny")==null?BigDecimal.ZERO:new BigDecimal(object.get("sumInvoiceAllTaxMny").toString()); // 累计收票金额
        BigDecimal contractTaxMny = object.get("contractTaxMny")==null?BigDecimal.ZERO:new BigDecimal(object.get("contractTaxMny").toString()); // 合同金额
        String performanceStatus = object.get("performanceStatus")==null?"0":object.get("performanceStatus").toString();
        Integer changeStatus = object.get("changeStatus")==null?0:Integer.parseInt(object.get("changeStatus").toString());
        paymentRecordVO.setTotalSettleTaxMny(totalSettleTaxMny);
        paymentRecordVO.setTotalInvoiceTaxMny(totalInvoiceTaxMny);
        paymentRecordVO.setContractTaxMny(contractTaxMny);
        paymentRecordVO.setContractId(id);
        paymentRecordVO.setPerformanceStatus(performanceStatus);
        paymentRecordVO.setChangeStatus(changeStatus);
        LambdaQueryWrapper<PaymentEntity> lambda = Wrappers.<PaymentEntity>lambdaQuery();
        lambda.eq(PaymentEntity::getContractId,id);
        lambda.in(PaymentEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(PaymentEntity::getPaymentDate);
        List<PaymentEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            paymentRecordVO.setPaymentList(BeanMapper.mapList(entities, PaymentVO.class));
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentRecordVO.setTotalPaymentTaxMny(totalPaymentTaxMny);
        }
        return paymentRecordVO;
    }
}
