package com.ejianc.business.jlcost.finance.consts;

/**
 * 项目中标状态枚举
 */
public enum ProjectStatusEnum {

    // 投标中
    投标中("投标中", 1),
    // 未中标
    未中标("未中标", 2),
    // 已中标
    已中标("已中标", 3);

    private String name;
    private Integer code;

    public static Integer getCodeByName(String name) {

        for (ProjectStatusEnum value : ProjectStatusEnum.values()) {
            if (value.getName().equals(name)) {
                return value.getCode();
            }
        }
        return null;
    }


    ProjectStatusEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
