package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.finance.bean.InvoiceDetailEntity;
import com.ejianc.business.jlcost.finance.service.IInvoiceDetailService;
import com.ejianc.business.jlcost.finance.vo.InvoiceDetailVO;
import com.ejianc.business.jlcost.finance.vo.InvoiceListVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.InvoiceMapper;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
@Service("invoiceService")
public class InvoiceServiceImpl extends BaseServiceImpl<InvoiceMapper, InvoiceEntity> implements IInvoiceService{


    @Autowired
    private IInvoiceDetailService detailService;

    @Override
    public InvoiceListVO getContractInvoice(Long contractId) {
        QueryParam param = new QueryParam();
        //根据合同ID查询
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        //查询生效过滤
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        List<InvoiceEntity> list = super.queryList(param);
        if (list.size() == 0) {
            InvoiceListVO result = new InvoiceListVO();
            result.setCumulativeMny(BigDecimal.ZERO);
            result.setInvoiceDetailList(new ArrayList<>());
            return result;
        }
        List<Long> ids = list.stream().map(invoice -> invoice.getId()).collect(Collectors.toList());
        List<InvoiceDetailEntity> InvoiceDetailList = detailService.list(new QueryWrapper<InvoiceDetailEntity>().in("invoice_id", ids));
        List<InvoiceDetailVO> resData = BeanMapper.mapList(InvoiceDetailList, InvoiceDetailVO.class);
        BigDecimal countMny = resData.size() > 0 ? resData.stream().map(e -> e.getDetailTaxMny()).reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        InvoiceListVO result = new InvoiceListVO();
        result.setCumulativeMny(countMny);
        result.setInvoiceDetailList(resData);
        return result;
    }

    @Override
    public Map<Long, InvoiceListVO> getContractInvoiceByContractIdList(List<Long> ids) {
        Map<Long, InvoiceListVO> collectMap = new HashMap<>();
        QueryParam param = new QueryParam();
        //根据合同ID查询
        param.getParams().put("contractId", new Parameter(QueryParam.IN, ids));
        //查询生效过滤
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        List<InvoiceEntity> list = super.queryList(param);

        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Map<Long, List<InvoiceEntity>> invoiceDataMap = list.stream().collect(Collectors.groupingBy(InvoiceEntity::getContractId));
            for (Long contractId : invoiceDataMap.keySet()) {
                List<Long> invoiceIdList = invoiceDataMap.get(contractId).stream().map(invoice -> invoice.getId()).collect(Collectors.toList());
                List<InvoiceDetailEntity> InvoiceDetailList = detailService.list(new QueryWrapper<InvoiceDetailEntity>().in("invoice_id", invoiceIdList));
                List<InvoiceDetailVO> resData = BeanMapper.mapList(InvoiceDetailList, InvoiceDetailVO.class);
                BigDecimal countMny = resData.size() > 0 ? resData.stream().map(e -> e.getDetailTaxMny()).reduce(BigDecimal::add).get() : BigDecimal.ZERO;
                InvoiceListVO result = new InvoiceListVO();
                result.setCumulativeMny(countMny);
                result.setInvoiceDetailList(resData);
                collectMap.put(contractId, result);
            }
        }
        return collectMap;
    }
}
