/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.controller.SqlParam;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.ProductCostVO;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.mapper.ContractMapper;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warn/"})
public class WarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PROJECT_BALANCE_WARN_NAME = "\u9879\u76ee\u865a\u62df\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3";
    private static final String PRODUCT_COST_WARN_NAME = "\u4ea7\u54c1\u751f\u4ea7\u6210\u672c\u8d85\u989d";
    private static final String PROJECT_SJCOST_WARN_NAME = "\u9879\u76ee\u865a\u62df\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3";
    private static final String FINANCE_REPORT_URL = "/ejc-jlcost-frontend/#/financeReport?projectId=";
    private static final String PRODUCT_COST_URL = "/ejc-jlcost-frontend/#/targetCostExecution?projectId=";
    private static final String TARGET_COST_URL = "/ejc-jlcost-frontend/#/targetCostExecution?projectId=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ContractMapper contractMapper;

    @PostMapping(value={"projectBalanceWarn"})
    public CommonResponse<String> projectBalanceWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<FinanceReportVO> recordVOList = this.contractMapper.queryProjectBalance();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u865a\u62df\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u83b7\u5f97\u9879\u76ee\u865a\u62df\u8d44\u91d1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        CommonResponse res = this.projectApi.getProjectArchiveByIds(recordVOList.stream().map(FinanceReportVO::getProjectId).collect(Collectors.toList()));
        Map<Object, Object> projectMap = new HashMap();
        if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
            projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (FinanceReportVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            List sqlParams = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            Double value = ((SqlParam)sqlParams.get(0)).getValue();
            BigDecimal warnMny = ComputeUtil.safeMultiply((BigDecimal)reportVO.getReceiveMny(), (BigDecimal)new BigDecimal(value / 100.0));
            if (reportVO.getPaymentMny().compareTo(warnMny) <= 0) continue;
            ProjectArchiveVO projectArchiveVO = (ProjectArchiveVO)projectMap.get(reportVO.getProjectId());
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(projectArchiveVO.getName());
            vo.setPcTitle("\u9879\u76ee\u865a\u62df\u8d44\u91d1\u8d26\u6237\u7edf\u8ba1");
            vo.setPcUrl(FINANCE_REPORT_URL + reportVO.getProjectId().toString() + "&projectName=" + projectArchiveVO.getName());
            vo.setOrgId(projectArchiveVO.getOrgId());
            vo.setOrgName(projectArchiveVO.getOrgName());
            vo.setSourceId(reportVO.getProjectId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectArchiveVO.getName()).replaceAll("#receiveMny#", df.format(this.getBigDecimal(reportVO.getReceiveMny()))).replaceAll("#paymentMny#", df.format(this.getBigDecimal(reportVO.getPaymentMny()))).replaceAll("#virtualMny#", df.format(this.getBigDecimal(ComputeUtil.safeSub((BigDecimal)reportVO.getReceiveMny(), (BigDecimal)reportVO.getPaymentMny())))));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"productCostWarn"})
    public CommonResponse<String> productCostWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ProductCostVO> productCostVOList = this.contractMapper.queryProductCost();
        if (CollectionUtils.isEmpty(productCostVOList)) {
            this.logger.error("\u6267\u884c\u4ea7\u54c1\u751f\u4ea7\u6210\u672c\u8d85\u989d\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u83b7\u5f97\u9879\u76ee\u76ee\u6807\u6210\u672c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(productCostVOList));
        CommonResponse res = this.projectApi.getProjectArchiveByIds(productCostVOList.stream().map(ProductCostVO::getProjectId).collect(Collectors.toList()));
        Map<Object, Object> projectMap = new HashMap();
        if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
            projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (ProductCostVO productCostVO : productCostVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            List sqlParams = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            Double value = ((SqlParam)sqlParams.get(0)).getValue();
            BigDecimal mny = productCostVO.getMny();
            BigDecimal mbmny = productCostVO.getMbMny();
            BigDecimal warnMny = ComputeUtil.safeMultiply((BigDecimal)mbmny, (BigDecimal)new BigDecimal(value / 100.0));
            if (mny == null) {
                mny = new BigDecimal(0);
            }
            if (mny.compareTo(warnMny) <= 0) continue;
            ProjectArchiveVO projectArchiveVO = (ProjectArchiveVO)projectMap.get(productCostVO.getProjectId());
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(projectArchiveVO.getName());
            vo.setPcTitle("\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
            vo.setPcUrl("/ejc-jlcost-frontend/#/targetCostExecution?projectId=" + productCostVO.getProjectId().toString() + "&projectName=" + projectArchiveVO.getName());
            vo.setOrgId(projectArchiveVO.getOrgId());
            vo.setOrgName(projectArchiveVO.getOrgName());
            vo.setSourceId(productCostVO.getProjectId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName") + "-" + productCostVO.getWbsName());
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            System.out.println(tmpContent);
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectArchiveVO.getName()).replaceAll("#wbsName#", productCostVO.getWbsName()).replaceAll("#mny#", df.format(this.getBigDecimal(productCostVO.getMny()))).replaceAll("#mbmny#", df.format(this.getBigDecimal(productCostVO.getMbMny()))).replaceAll("#exceedMny#", df.format(this.getBigDecimal(ComputeUtil.safeSub((BigDecimal)productCostVO.getMny(), (BigDecimal)productCostVO.getMbMny())))));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

    @PostMapping(value={"projectSjCostWarn"})
    public CommonResponse<String> projectSjCostWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<SjCostReportVO> recordList = this.contractMapper.queryProjectSjCost();
        if (CollectionUtils.isEmpty(recordList)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u865a\u62df\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u83b7\u5f97\u5b9e\u9645\u76ee\u6807\u603b\u6210\u672c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(recordList));
        List ids = recordList.stream().map(SjCostReportVO::getProjectId).collect(Collectors.toList());
        CommonResponse res = this.projectApi.getProjectArchiveByIds(ids);
        Map<Object, Object> projectMap = new HashMap();
        if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
            projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        }
        List targetList = this.targetService.list((Wrapper)new QueryWrapper().in((Object)"project_id", ids));
        Map<Long, BigDecimal> targetMap = targetList.stream().collect(Collectors.toMap(TargetEntity::getProjectId, TargetEntity::getCostMny));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (SjCostReportVO reportVO : recordList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            List sqlParams = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            Double value = ((SqlParam)sqlParams.get(0)).getValue();
            BigDecimal targetMny = targetMap.get(reportVO.getProjectId());
            if (targetMny == null) continue;
            BigDecimal warnMny = ComputeUtil.safeMultiply((BigDecimal)targetMny, (BigDecimal)new BigDecimal(value / 100.0));
            if (reportVO.getMny().compareTo(warnMny) <= 0) continue;
            ProjectArchiveVO projectArchiveVO = (ProjectArchiveVO)projectMap.get(reportVO.getProjectId());
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(projectArchiveVO.getName());
            vo.setPcTitle("\u9879\u76ee\u76ee\u6807\u6210\u672c\u6267\u884c\u60c5\u51b5");
            vo.setPcUrl("/ejc-jlcost-frontend/#/targetCostExecution?projectId=" + reportVO.getProjectId().toString() + "&projectName" + projectArchiveVO.getName());
            vo.setOrgId(projectArchiveVO.getOrgId());
            vo.setOrgName(projectArchiveVO.getOrgName());
            vo.setSourceId(reportVO.getProjectId().toString());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectArchiveVO.getName()).replaceAll("#costMny#", df.format(this.getBigDecimal(reportVO.getMny()))).replaceAll("#targetMny#", df.format(this.getBigDecimal(targetMny))).replaceAll("#exceedMny#", df.format(this.getBigDecimal(ComputeUtil.safeSub((BigDecimal)reportVO.getMny(), (BigDecimal)targetMny)))));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }
}

