package com.ejianc.business.jlcost.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 资金管理-收票登记
 *
 * @author generator
 *
 */
 @TableName("ejc_finance_collect")
public class CollectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="contract_type")
    private String contractType; // 合同类型 1-外协加工合同,2-成品采购合同,3-整体外包合同,4-场地或设备租赁合同,5-外部检测合同,6-外部设计合同,7-外部产品认证合同,8-劳务分包合同,9-设备或材料采购合同,10-设备租赁合同
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="customer_id")
    private Long customerId; // 购方主键
    @TableField(value="customer_name")
    private String customerName; // 购方名称
    @TableField(value="supplier_name")
    private String supplierName; // 销方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 销方主键
    @TableField(value="project_type")
    private String projectType; // 是否属于项目 1-项目，2-公司
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 登记日期
    @TableField(value="invoice_mny")
    private BigDecimal invoiceMny; // 发票金额（不含税）
    @TableField(value="invoice_tax")
    private BigDecimal invoiceTax; // 税金
    @TableField(value="invoice_tax_mny")
    private BigDecimal invoiceTaxMny; // 发票金额
    @TableField(value="sum_invoice_mny")
    private BigDecimal sumInvoiceMny; // 累计收票金额(不含本期)(无税)
    @TableField(value="sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny; // 累计收票金额(不含本期)
    @TableField(value="sum_invoice_all_mny")
    private BigDecimal sumInvoiceAllMny; // 累计收票金额(无税)
    @TableField(value="sum_invoice_all_tax_mny")
    private BigDecimal sumInvoiceAllTaxMny; // 累计收票金额
    @TableField(value="bill_code")
    private String billCode; // 申请单编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称


    @TableField(exist=false)
    @SubEntity(serviceName="collectDetailService", pidName = "collectId")
    private List<CollectDetailEntity> detailList = new ArrayList<>(); // 资金管理-收票登记明细


    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getInvoiceTax() {
        return invoiceTax;
    }

    public void setInvoiceTax(BigDecimal invoiceTax) {
        this.invoiceTax = invoiceTax;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    public BigDecimal getSumInvoiceAllMny() {
        return sumInvoiceAllMny;
    }

    public void setSumInvoiceAllMny(BigDecimal sumInvoiceAllMny) {
        this.sumInvoiceAllMny = sumInvoiceAllMny;
    }

    public BigDecimal getSumInvoiceAllTaxMny() {
        return sumInvoiceAllTaxMny;
    }

    public void setSumInvoiceAllTaxMny(BigDecimal sumInvoiceAllTaxMny) {
        this.sumInvoiceAllTaxMny = sumInvoiceAllTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public List<CollectDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CollectDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
