/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.bean.TargetDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetDetailService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.ProjectRecordVO;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportCostVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetReportVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"costReport"})
public class CostReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetDetailService targetDetailService;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private TargetMapper targetMapper;

    @RequestMapping(value={"/queryCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCost(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.querySjCostList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelCost"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCost(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("costType");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.querySjCostList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("costReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryFinancec(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.contractService.queryFinanceList(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelFinance"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("projectId")) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.contractService.queryFinanceList(page, wrapper);
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("financeReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getFinanceMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getFinanceMny(Long projectId) {
        return CommonResponse.success((Object)this.contractService.queryFinanceSum(projectId));
    }

    @RequestMapping(value={"/queryTargetReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TargetReportVO> queryTargetReport(Long projectId) {
        TargetReportVO vo = new TargetReportVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(TargetEntity::getProjectId, (Object)projectId);
        lambda.in(TargetEntity::getBillState, new Object[]{1, 3});
        List targetEntityList = this.targetService.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)targetEntityList)) {
            TargetEntity targetEntity = (TargetEntity)((Object)targetEntityList.get(0));
            List<SjCostReportVO> sjList = this.contractService.querySjDetailMny(projectId);
            List<SjCostReportVO> materialList = this.contractService.queryMaterialMny(projectId);
            HashMap map = new HashMap();
            HashMap<Long, BigDecimal> materialMap = new HashMap<Long, BigDecimal>();
            BigDecimal sjCostMny = BigDecimal.ZERO;
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(sjList)) {
                Object wbsId = null;
                for (SjCostReportVO sjvo : sjList) {
                    Map<Integer, BigDecimal> map1;
                    wbsId = null != sjvo.getWbsId() ? sjvo.getWbsId() : Long.valueOf(99L);
                    if (map.containsKey(wbsId)) {
                        map1 = (Map)map.get(wbsId);
                        map1.put(sjvo.getCostType(), sjvo.getMny());
                        map.put(wbsId, map1);
                        continue;
                    }
                    map1 = new HashMap();
                    map1.put(sjvo.getCostType(), sjvo.getMny());
                    map.put(wbsId, map1);
                }
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(materialList)) {
                for (SjCostReportVO sjvo : materialList) {
                    if (materialMap.containsKey(sjvo.getWbsId())) {
                        BigDecimal materialCostMny = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)materialMap.get(sjvo.getWbsId())), (BigDecimal)sjvo.getMny());
                        materialMap.put(sjvo.getWbsId(), materialCostMny);
                        continue;
                    }
                    materialMap.put(sjvo.getWbsId(), sjvo.getMny());
                }
            }
            vo.setProjectId(projectId);
            vo.setProjectCode(targetEntity.getProjectCode());
            vo.setProjectName(targetEntity.getProjectName());
            TargetVO targetVO = this.targetMapper.queryContractTaxMnyByProjectId(projectId);
            if (null != targetVO) {
                vo.setContractMny(targetVO.getContractMny());
                vo.setContractTaxMny(targetVO.getContractTaxMny());
            }
            vo.setCostMny(targetEntity.getCostMny());
            vo.setPlanProfitMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getCostMny()));
            LambdaQueryWrapper lambdab = Wrappers.lambdaQuery();
            lambdab.eq(TargetDetailEntity::getTargetId, (Object)targetEntity.getId());
            List targetDetailEntities = this.targetDetailService.list((Wrapper)lambdab);
            Map<Long, TargetDetailEntity> idMap = targetDetailEntities.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)targetDetailEntities)) {
                ArrayList resList = new ArrayList();
                HashSet set = new HashSet();
                HashMap<Long, BigDecimal> mbMap = new HashMap<Long, BigDecimal>();
                HashMap<Long, TargetReportDetailVO> detailMap = new HashMap<Long, TargetReportDetailVO>();
                List list = BeanMapper.mapList((Iterable)targetDetailEntities, TargetReportDetailVO.class);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
                    for (TargetReportDetailVO detailVO : list) {
                        if (null != detailVO.getRowType() && 5 == detailVO.getRowType()) {
                            Long wbsId = idMap.get(detailVO.getParentId()).getSourceId();
                            if (null != detailVO.getCostType() && 0 == detailVO.getCostType()) {
                                if (mbMap.containsKey(wbsId)) {
                                    BigDecimal materialCostMny = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)mbMap.get(wbsId)), (BigDecimal)detailVO.getMny());
                                    mbMap.put(wbsId, materialCostMny);
                                } else {
                                    mbMap.put(wbsId, detailVO.getMny());
                                }
                            }
                        }
                        detailMap.put(detailVO.getId(), detailVO);
                    }
                }
                list.forEach(e -> {
                    if (null != e.getCostType() && 0 != e.getCostType()) {
                        Long wbsId = null;
                        wbsId = 2 == e.getRowLevel() && (2 == e.getCostType() || 3 == e.getCostType() || 4 == e.getCostType() || 5 == e.getCostType()) ? ((TargetReportDetailVO)detailMap.get(e.getParentId())).getSourceId() : Long.valueOf(99L);
                        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Map)map) && null != map.get(wbsId)) {
                            e.setSjCostMny((BigDecimal)((Map)map.get(wbsId)).get(e.getCostType()));
                        }
                        resList.add(e);
                    } else if (null != e.getCostType() && 0 == e.getCostType()) {
                        Long wbsId = ((TargetDetailEntity)((Object)((Object)idMap.get(e.getParentId())))).getSourceId();
                        if (!set.contains(wbsId)) {
                            TargetReportDetailVO detailVO = new TargetReportDetailVO();
                            detailVO.setId(Long.valueOf(wbsId + 99L));
                            detailVO.setCode(((TargetDetailEntity)((Object)((Object)idMap.get(e.getParentId())))).getCode() + "01");
                            detailVO.setName("\u6750\u6599\u8d39");
                            detailVO.setCostType(Integer.valueOf(0));
                            detailVO.setRowLevel(Integer.valueOf(3));
                            detailVO.setRowType(Integer.valueOf(5));
                            detailVO.setSourceId(wbsId);
                            detailVO.setMny((BigDecimal)mbMap.get(wbsId));
                            detailVO.setSjCostMny((BigDecimal)materialMap.get(wbsId));
                            detailVO.setParentId(e.getParentId());
                            resList.add(detailVO);
                            set.add(wbsId);
                        }
                    } else if (null == e.getCostType()) {
                        resList.add(e);
                    }
                });
                resList.forEach(e -> {
                    if (2 == e.getRowLevel() && 3 == e.getRowType()) {
                        e.setSjCostMny(this.getCostMny((TargetReportDetailVO)e, resList, 3));
                    }
                });
                resList.forEach(e -> {
                    if (1 == e.getRowLevel() && 1 == e.getRowType()) {
                        e.setSjCostMny(this.getCostMny((TargetReportDetailVO)e, resList, 2));
                    }
                });
                for (TargetReportDetailVO e2 : resList) {
                    if (1 != e2.getRowLevel()) continue;
                    sjCostMny = ComputeUtil.safeAdd((BigDecimal)sjCostMny, (BigDecimal)e2.getSjCostMny());
                }
                vo.setSjCostMny(sjCostMny);
                vo.setSjProfitMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getSjCostMny()));
                vo.setDetailList(TreeNodeBUtil.buildTree(resList));
            }
            List<SjCostReportVO> costAllList = this.contractService.querySjCostMny(projectId);
            HashMap<Integer, BigDecimal> costMap = new HashMap<Integer, BigDecimal>();
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costAllList)) {
                for (SjCostReportVO sjvo : costAllList) {
                    costMap.put(sjvo.getCostType(), sjvo.getMny());
                }
            }
            vo.setCostList(this.getTargetReportCostVO(targetEntity, vo, costMap));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMaterialSum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TargetMaterialDetailVO>> queryMaterialSum(Long projectId, Long wbsId) {
        return CommonResponse.success(this.contractService.queryMaterialSum(projectId, wbsId));
    }

    @RequestMapping(value={"/queryMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryMaterialList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("code");
        fuzzyFields.add("spec");
        fuzzyFields.add("name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Long projectId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("projectId")).getValue()));
        Long wbsId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("wbsId")).getValue()));
        Long materialId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("materialId")).getValue()));
        RecordVOList = this.contractService.queryMaterialList(page, wrapper, projectId, wbsId, materialId);
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryWorkTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryWorkTime(Long projectId, Long wbsId) {
        return CommonResponse.success((Object)this.contractService.queryWorkTime(projectId, wbsId));
    }

    @RequestMapping(value={"/queryWorkTimeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryWorkTimeList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Long projectId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("projectId")).getValue()));
        Long wbsId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("wbsId")).getValue()));
        RecordVOList = this.contractService.queryWorkTimeList(page, wrapper, projectId, wbsId);
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    public List<TargetReportCostVO> getTargetReportCostVO(TargetEntity targetEntity, TargetReportVO vo, Map<Integer, BigDecimal> costMap) {
        ArrayList<TargetReportCostVO> costList = new ArrayList<TargetReportCostVO>();
        TargetReportCostVO targetReportCostVO = (TargetReportCostVO)BeanMapper.map((Object)((Object)targetEntity), TargetReportCostVO.class);
        targetReportCostVO.setId(Long.valueOf(1L));
        targetReportCostVO.setName("\u76ee\u6807\u6210\u672c");
        targetReportCostVO.setCostMny(vo.getCostMny());
        costList.add(targetReportCostVO);
        TargetReportCostVO targetReportCostVO2 = new TargetReportCostVO();
        targetReportCostVO2.setId(Long.valueOf(2L));
        targetReportCostVO2.setName("\u5b9e\u9645\u6210\u672c");
        targetReportCostVO2.setCostMny(vo.getSjCostMny());
        if (null != costMap) {
            targetReportCostVO2.setMaterialMny(costMap.get(0));
            targetReportCostVO2.setLaborMny(costMap.get(1));
            targetReportCostVO2.setMakeMny(costMap.get(2));
            targetReportCostVO2.setSpecialMny(costMap.get(3));
            targetReportCostVO2.setWxjgMny(costMap.get(4));
            targetReportCostVO2.setWgcpMny(costMap.get(5));
            targetReportCostVO2.setXcsgMny(costMap.get(6));
            targetReportCostVO2.setXczzMny(costMap.get(7));
            targetReportCostVO2.setWbsjMny(costMap.get(8));
            targetReportCostVO2.setTransportMny(costMap.get(9));
            targetReportCostVO2.setZtwbMny(costMap.get(10));
            targetReportCostVO2.setOtherMny(costMap.get(11));
        }
        costList.add(targetReportCostVO2);
        TargetReportCostVO targetReportCostVO3 = new TargetReportCostVO();
        targetReportCostVO3.setId(Long.valueOf(3L));
        targetReportCostVO3.setName("\u76ee\u6807-\u5b9e\u9645");
        targetReportCostVO3.setCostMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getCostMny(), (BigDecimal)targetReportCostVO2.getCostMny()));
        targetReportCostVO3.setMaterialMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getMaterialMny(), (BigDecimal)targetReportCostVO2.getMaterialMny()));
        targetReportCostVO3.setLaborMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getLaborMny(), (BigDecimal)targetReportCostVO2.getLaborMny()));
        targetReportCostVO3.setMakeMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getMakeMny(), (BigDecimal)targetReportCostVO2.getMakeMny()));
        targetReportCostVO3.setSpecialMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getSpecialMny(), (BigDecimal)targetReportCostVO2.getSpecialMny()));
        targetReportCostVO3.setWxjgMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWxjgMny(), (BigDecimal)targetReportCostVO2.getWxjgMny()));
        targetReportCostVO3.setWgcpMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWgcpMny(), (BigDecimal)targetReportCostVO2.getWgcpMny()));
        targetReportCostVO3.setXcsgMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getXcsgMny(), (BigDecimal)targetReportCostVO2.getXcsgMny()));
        targetReportCostVO3.setXczzMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getXczzMny(), (BigDecimal)targetReportCostVO2.getXczzMny()));
        targetReportCostVO3.setWbsjMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getWbsjMny(), (BigDecimal)targetReportCostVO2.getWbsjMny()));
        targetReportCostVO3.setTransportMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getTransportMny(), (BigDecimal)targetReportCostVO2.getTransportMny()));
        targetReportCostVO3.setZtwbMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getZtwbMny(), (BigDecimal)targetReportCostVO2.getZtwbMny()));
        targetReportCostVO3.setOtherMny(ComputeUtil.safeSub((BigDecimal)targetReportCostVO.getOtherMny(), (BigDecimal)targetReportCostVO2.getOtherMny()));
        costList.add(targetReportCostVO3);
        return costList;
    }

    public BigDecimal getCostMny(TargetReportDetailVO vo, List<TargetReportDetailVO> list, int rowType) {
        BigDecimal costMny = BigDecimal.ZERO;
        for (TargetReportDetailVO e : list) {
            if (null == e.getRowLevel() || rowType != e.getRowLevel() || !e.getParentId().equals(vo.getId())) continue;
            costMny = ComputeUtil.safeAdd((BigDecimal)costMny, (BigDecimal)e.getSjCostMny());
        }
        return costMny;
    }

    @RequestMapping(value={"/queryProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectRecordVO>> queryProjectList(@RequestBody QueryParam param) {
        CommonResponse projectResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        if (!param.getParams().containsKey("projectStatus")) {
            param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
        }
        if (param.getParams().containsKey("projectName")) {
            param.getParams().put("name", new Parameter("like", ((Parameter)param.getParams().get("projectName")).getValue()));
            param.getParams().remove("projectName");
        }
        if (!(projectResponse = this.projectArchiveApi.queryProjectArchivePage(param)).isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        List<Object> RecordVOList = new ArrayList();
        ArrayList resList = new ArrayList();
        RecordVOList = this.contractService.queryProjectList();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> map.put(e.getProjectId() + "||" + e.getType(), e));
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectId(e.getId());
                projectRecordVO.setProjectStatus(Integer.valueOf(Integer.parseInt(e.getProjectStatus())));
                projectRecordVO.setProjectName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setProjectDate(e.getProjectDate());
                if (map.containsKey(e.getId() + "||" + 1)) {
                    projectRecordVO.setContractTaxMny(map.get(e.getId() + "||" + 1) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 1)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 2)) {
                    projectRecordVO.setSettleTaxMny(map.get(e.getId() + "||" + 2) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 2)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 3)) {
                    projectRecordVO.setCostMny(map.get(e.getId() + "||" + 3) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 3)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 4)) {
                    projectRecordVO.setSjMny(map.get(e.getId() + "||" + 4) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 4)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 5)) {
                    projectRecordVO.setInvoiceTaxMny(map.get(e.getId() + "||" + 5) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 5)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 6)) {
                    projectRecordVO.setReceiveMny(map.get(e.getId() + "||" + 6) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 6)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 7)) {
                    projectRecordVO.setPaymentTaxMny(map.get(e.getId() + "||" + 7) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 7)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 8)) {
                    projectRecordVO.setCollentTaxMny(map.get(e.getId() + "||" + 8) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 8)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 9)) {
                    projectRecordVO.setProjectMny(map.get(e.getId() + "||" + 9) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 9)).getMny());
                }
                projectRecordVO.setPlanProfitMny(ComputeUtil.safeSub((BigDecimal)projectRecordVO.getContractTaxMny(), (BigDecimal)projectRecordVO.getCostMny()));
                projectRecordVO.setSjProfitMny(ComputeUtil.safeSub((BigDecimal)projectRecordVO.getContractTaxMny(), (BigDecimal)projectRecordVO.getSjMny()));
                projectRecordVO.setPlanProfitScale(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)projectRecordVO.getPlanProfitMny(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)projectRecordVO.getContractTaxMny()));
                projectRecordVO.setSjProfitScale(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)projectRecordVO.getSjProfitMny(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)projectRecordVO.getContractTaxMny()));
                resList.add(projectRecordVO);
            });
        }
        Page pageData = new Page(((Page)projectResponse.getData()).getCurrent(), ((Page)projectResponse.getData()).getSize(), ((Page)projectResponse.getData()).getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelProjectList(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
        CommonResponse projectResponse = this.projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        List<Object> RecordVOList = new ArrayList();
        ArrayList resList = new ArrayList();
        RecordVOList = this.contractService.queryProjectList();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> map.put(e.getProjectId() + "||" + e.getType(), e));
        }
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectId(e.getId());
                projectRecordVO.setProjectStatus(Integer.valueOf(Integer.parseInt(e.getProjectStatus())));
                projectRecordVO.setProjectName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setProjectDate(e.getProjectDate());
                if (map.containsKey(e.getId() + "||" + 1)) {
                    projectRecordVO.setContractTaxMny(map.get(e.getId() + "||" + 1) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 1)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 2)) {
                    projectRecordVO.setSettleTaxMny(map.get(e.getId() + "||" + 2) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 2)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 3)) {
                    projectRecordVO.setCostMny(map.get(e.getId() + "||" + 3) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 3)).getMny());
                }
                if (map.containsKey(e.getId() + "||" + 4)) {
                    projectRecordVO.setSjMny(map.get(e.getId() + "||" + 4) == null ? BigDecimal.ZERO : ((ProjectRecordVO)map.get(e.getId() + "||" + 4)).getMny());
                }
                projectRecordVO.setPlanProfitMny(ComputeUtil.safeSub((BigDecimal)projectRecordVO.getContractTaxMny(), (BigDecimal)projectRecordVO.getCostMny()));
                projectRecordVO.setSjProfitMny(ComputeUtil.safeSub((BigDecimal)projectRecordVO.getContractTaxMny(), (BigDecimal)projectRecordVO.getSjMny()));
                projectRecordVO.setPlanProfitScale(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)projectRecordVO.getPlanProfitMny(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)projectRecordVO.getContractTaxMny()));
                projectRecordVO.setSjProfitScale(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)projectRecordVO.getSjProfitMny(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)projectRecordVO.getContractTaxMny()));
                resList.add(projectRecordVO);
            });
        }
        resList.forEach(vo -> {
            Integer projectStatus = vo.getProjectStatus();
            if (projectStatus == 1) {
                vo.setProjectStatusName("\u5546\u673a\u9636\u6bb5");
            }
            if (projectStatus == 2) {
                vo.setProjectStatusName("\u6295\u6807\u9636\u6bb5");
            }
            if (projectStatus == 3) {
                vo.setProjectStatusName("\u672a\u4e2d\u6807");
            }
            if (projectStatus == 4) {
                vo.setProjectStatusName("\u5df2\u4e2d\u6807");
            }
            if (projectStatus == 5) {
                vo.setProjectStatusName("\u5408\u540c\u9636\u6bb5");
            }
            if (projectStatus == 6) {
                vo.setProjectStatusName("\u751f\u4ea7\u9636\u6bb5");
            }
            if (projectStatus == 7) {
                vo.setProjectStatusName("\u4f9b\u8d27\u9636\u6bb5");
            }
            if (projectStatus == 8) {
                vo.setProjectStatusName("\u7ed3\u7b97\u9636\u6bb5");
            }
            if (projectStatus == 9) {
                vo.setProjectStatusName("\u5b8c\u5de5");
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("projectListReport-export.xlsx", beans, response);
    }
}

