/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.mapper.InvoiceMapper;
import com.ejianc.business.jlcost.finance.service.IInvoiceDetailService;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.vo.InvoiceDetailVO;
import com.ejianc.business.jlcost.finance.vo.InvoiceListVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceService")
public class InvoiceServiceImpl
extends BaseServiceImpl<InvoiceMapper, InvoiceEntity>
implements IInvoiceService {
    @Autowired
    private IInvoiceDetailService detailService;

    @Override
    public InvoiceListVO getContractInvoice(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        List list = super.queryList(param);
        if (list.size() == 0) {
            InvoiceListVO result = new InvoiceListVO();
            result.setCumulativeMny(BigDecimal.ZERO);
            result.setInvoiceDetailList(new ArrayList());
            return result;
        }
        List ids = list.stream().map(invoice -> invoice.getId()).collect(Collectors.toList());
        List InvoiceDetailList = this.detailService.list((Wrapper)new QueryWrapper().in((Object)"invoice_id", ids));
        List resData = BeanMapper.mapList((Iterable)InvoiceDetailList, InvoiceDetailVO.class);
        BigDecimal countMny = resData.size() > 0 ? resData.stream().map(e -> e.getDetailTaxMny()).reduce(BigDecimal::add).get() : BigDecimal.ZERO;
        InvoiceListVO result = new InvoiceListVO();
        result.setCumulativeMny(countMny);
        result.setInvoiceDetailList(resData);
        return result;
    }

    @Override
    public Map<Long, InvoiceListVO> getContractInvoiceByContractIdList(List<Long> ids) {
        HashMap<Long, InvoiceListVO> collectMap = new HashMap<Long, InvoiceListVO>();
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("in", ids));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<InvoiceEntity>> invoiceDataMap = list.stream().collect(Collectors.groupingBy(InvoiceEntity::getContractId));
            for (Long contractId : invoiceDataMap.keySet()) {
                List invoiceIdList = invoiceDataMap.get(contractId).stream().map(invoice -> invoice.getId()).collect(Collectors.toList());
                List InvoiceDetailList = this.detailService.list((Wrapper)new QueryWrapper().in((Object)"invoice_id", invoiceIdList));
                List resData = BeanMapper.mapList((Iterable)InvoiceDetailList, InvoiceDetailVO.class);
                BigDecimal countMny = resData.size() > 0 ? resData.stream().map(e -> e.getDetailTaxMny()).reduce(BigDecimal::add).get() : BigDecimal.ZERO;
                InvoiceListVO result = new InvoiceListVO();
                result.setCumulativeMny(countMny);
                result.setInvoiceDetailList(resData);
                collectMap.put(contractId, result);
            }
        }
        return collectMap;
    }
}

