/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractClauseVO;
import com.ejianc.business.jlcost.payout.vo.ContractDetailVO;
import com.ejianc.business.jlcost.payout.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IContractService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractVO contractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContractReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryContractReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
            param.getParams().remove("projectId");
        }
        if ("5".equals(InvocationInfoProxy.getOrgType()) || null != projectId) {
            List<Object> resList = new ArrayList();
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            resList = null != projectId ? this.service.queryContractList(page, wrapper, projectId, null) : this.service.queryContractList(page, wrapper, null, orgId);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(resList);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        param.getComplexParams().add(this.getPageQueryParam(null));
        List<Object> resList = new ArrayList();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        resList = this.service.queryContractOrgList(page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.iOrgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("project_type", new Parameter("eq", (Object)"2"));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        }
        return c1;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractVO contractVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVO.getId());
        updateWrapper.set(ContractEntity::getPerformanceStatus, (Object)contractVO.getPerformanceStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getComplexParams().add(this.getPageQueryParam(null));
        List list = this.service.queryList(param);
        List records = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            records = BeanMapper.mapList((Iterable)list, ContractVO.class);
            records.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if ("1".equals(vo.getPerformanceStatus())) {
                    vo.setPerformanceStatusName("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getPerformanceStatus())) {
                    vo.setPerformanceStatusName("\u5c65\u7ea6\u4e2d");
                } else {
                    vo.setPerformanceStatusName("\u5df2\u5c01\u8d26");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/reportExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void reportExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long orgId = InvocationInfoProxy.getOrgId();
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
            param.getParams().remove("projectId");
        }
        if ("5".equals(InvocationInfoProxy.getOrgType()) || null != projectId) {
            List<Object> resList = new ArrayList();
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            resList = null != projectId ? this.service.queryContractList(page, wrapper, projectId, null) : this.service.queryContractList(page, wrapper, null, orgId);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            resList.forEach(e -> {
                if ((long)e.getContractType().intValue() == 1L) {
                    e.setContractTypeName("\u5916\u534f\u52a0\u5de5\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 2L) {
                    e.setContractTypeName("\u6210\u54c1\u91c7\u8d2d\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 3L) {
                    e.setContractTypeName("\u6574\u4f53\u5916\u5305\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 4L) {
                    e.setContractTypeName("\u573a\u5730\u6216\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 5L) {
                    e.setContractTypeName("\u5916\u90e8\u68c0\u6d4b\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 6L) {
                    e.setContractTypeName("\u5916\u90e8\u8bbe\u8ba1\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 7L) {
                    e.setContractTypeName("\u5916\u90e8\u4ea7\u54c1\u8ba4\u8bc1\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 8L) {
                    e.setContractTypeName("\u52b3\u52a1\u5206\u5305\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 9L) {
                    e.setContractTypeName("\u8bbe\u5907\u6216\u6750\u6599\u91c7\u8d2d\u5408\u540c");
                }
                if ((long)e.getContractType().intValue() == 10L) {
                    e.setContractTypeName("\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                }
                switch (e.getPerformanceStatus()) {
                    case "1": {
                        e.setPerformanceStatusName("\u672a\u7b7e\u8ba2");
                        break;
                    }
                    case "2": {
                        e.setPerformanceStatusName("\u5c65\u7ea6\u4e2d");
                        break;
                    }
                    case "3": {
                        e.setPerformanceStatusName("\u5df2\u5c01\u8d26");
                    }
                }
                switch (e.getChangeStatus()) {
                    case 1: {
                        e.setChangeStatusName("\u672a\u53d8\u66f4");
                        break;
                    }
                    case 2: {
                        e.setChangeStatusName("\u53d8\u66f4\u4e2d");
                        break;
                    }
                    case 3: {
                        e.setChangeStatusName("\u5df2\u53d8\u66f4");
                    }
                }
            });
            HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
            beans.put("records", resList);
            ExcelExport.getInstance().export("ContractReport-export.xlsx", beans, response);
        } else {
            param.getComplexParams().add(this.getPageQueryParam(null));
            List<Object> resList = new ArrayList();
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            resList = this.service.queryContractOrgList(page, wrapper);
            if (CollectionUtils.isNotEmpty(resList)) {
                resList.forEach(e -> {
                    if ((long)e.getContractType().intValue() == 1L) {
                        e.setContractTypeName("\u5916\u534f\u52a0\u5de5\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 2L) {
                        e.setContractTypeName("\u6210\u54c1\u91c7\u8d2d\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 3L) {
                        e.setContractTypeName("\u6574\u4f53\u5916\u5305\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 4L) {
                        e.setContractTypeName("\u573a\u5730\u6216\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 5L) {
                        e.setContractTypeName("\u5916\u90e8\u68c0\u6d4b\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 6L) {
                        e.setContractTypeName("\u5916\u90e8\u8bbe\u8ba1\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 7L) {
                        e.setContractTypeName("\u5916\u90e8\u4ea7\u54c1\u8ba4\u8bc1\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 8L) {
                        e.setContractTypeName("\u52b3\u52a1\u5206\u5305\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 9L) {
                        e.setContractTypeName("\u8bbe\u5907\u6216\u6750\u6599\u91c7\u8d2d\u5408\u540c");
                    }
                    if ((long)e.getContractType().intValue() == 10L) {
                        e.setContractTypeName("\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                    }
                    switch (e.getPerformanceStatus()) {
                        case "1": {
                            e.setPerformanceStatusName("\u672a\u7b7e\u8ba2");
                            break;
                        }
                        case "2": {
                            e.setPerformanceStatusName("\u5c65\u7ea6\u4e2d");
                            break;
                        }
                        case "3": {
                            e.setPerformanceStatusName("\u5df2\u5c01\u8d26");
                        }
                    }
                    switch (e.getChangeStatus()) {
                        case 1: {
                            e.setChangeStatusName("\u672a\u53d8\u66f4");
                            break;
                        }
                        case 2: {
                            e.setChangeStatusName("\u53d8\u66f4\u4e2d");
                            break;
                        }
                        case 3: {
                            e.setChangeStatusName("\u5df2\u53d8\u66f4");
                        }
                    }
                });
                HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
                beans.put("records", resList);
                ExcelExport.getInstance().export("ContractReport-export.xlsx", beans, response);
            }
        }
    }

    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                orgId = Long.valueOf(String.valueOf(_con.get((Object)"orgId")));
            }
            if (_con.containsKey((Object)"contractType")) {
                param.getParams().put("contractType", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"contractType"))));
            }
        }
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        param.getComplexParams().add(this.getPageQueryParam(orgId));
        param.getParams().put("performanceStatus", new Parameter("ne", (Object)3));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/ztwbDownloadContractDetail"})
    @ResponseBody
    public void ztwbDownloadContractDetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractDetailList-import.xlsx", (String)"\u6574\u4f53\u5916\u5305\u5408\u540c-\u5408\u540c\u6e05\u5355\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/ztwbExcelImportContractDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> ztwbExcelImportContractDetail(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractDetailVO> successList = new ArrayList<ContractDetailVO>();
        ArrayList<ContractDetailVO> errorList = new ArrayList<ContractDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractDetailVO detailVO = new ContractDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                if (ObjectUtils.isEmpty(datas.get(0))) {
                    detailVO.setMaterialCode(null);
                } else {
                    detailVO.setMaterialCode((String)datas.get(0));
                }
                try {
                    if (ObjectUtils.isEmpty(datas.get(1))) {
                        throw new Exception("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setMaterialName((String)datas.get(1));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (ObjectUtils.isEmpty(datas.get(2))) {
                    detailVO.setUnit(null);
                } else {
                    detailVO.setUnit((String)datas.get(2));
                }
                if (ObjectUtils.isEmpty(datas.get(3))) {
                    detailVO.setNum(new BigDecimal(0));
                } else {
                    try {
                        detailVO.setNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(3))));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                try {
                    if (ObjectUtils.isEmpty(datas.get(4))) {
                        throw new Exception("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setDetailTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(4))));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setDetailTaxMny(detailVO.getNum().multiply(detailVO.getDetailTaxPrice()));
                if (ObjectUtils.isEmpty(datas.get(6))) {
                    detailVO.setMemo(null);
                } else {
                    detailVO.setMemo((String)datas.get(6));
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/ztwbDownloadContractClause"})
    @ResponseBody
    public void ztwbDownloadContractClause(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractClauseList-import.xlsx", (String)"\u6574\u4f53\u5916\u5305\u5408\u540c-\u5408\u540c\u5173\u952e\u6761\u6b3e\u6a21\u677f");
    }

    @RequestMapping(value={"/ztwbExcelImportContractClause"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> ztwbExcelImportContractClause(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractClauseVO> successList = new ArrayList<ContractClauseVO>();
        ArrayList<ContractClauseVO> errorList = new ArrayList<ContractClauseVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractClauseVO detailVO = new ContractClauseVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                try {
                    if (ObjectUtils.isEmpty(datas.get(0))) {
                        throw new Exception("\u6761\u6b3e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    detailVO.setClauseName((String)datas.get(0));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (ObjectUtils.isEmpty(datas.get(1))) {
                    detailVO.setClauseContent(null);
                } else {
                    detailVO.setClauseContent((String)datas.get(1));
                }
                if (ObjectUtils.isEmpty(datas.get(2))) {
                    detailVO.setMemo(null);
                } else {
                    detailVO.setMemo((String)datas.get(2));
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

