package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.cost.vo.ProjectRecordVO;
import com.ejianc.business.jlcost.cost.vo.SzReportVO;
import com.ejianc.business.jlcost.cost.vo.TargetMaterialDetailVO;
import com.ejianc.business.jlcost.finance.vo.FinanceReportVO;
import com.ejianc.business.jlcost.payout.bean.ContractChangeEntity;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.enums.ChangeTypeEnum;
import com.ejianc.business.jlcost.payout.enums.PayoutTypeEnum;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;
import com.ejianc.business.jlcost.payout.service.IContractDetailService;
import com.ejianc.business.jlcost.payout.vo.ContractDetailVO;
import com.ejianc.business.jlcost.payout.vo.ContractVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.payout.mapper.ContractMapper;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支出合同-合同主表
 *
 * @author generator
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 外协加工合同
     */
    private static final String WXJG_BILL_CODE = "WXJG_BILL_CODE";
    /**
     * 成品采购合同
     */
    private static final String CPCG_BILL_CODE = "CPCG_BILL_CODE";
    /**
     * 整体外包合同
     */
    private static final String ZTWB_BILL_CODE = "ZTWB_BILL_CODE";
    /**
     * 场地或设备租赁合同
     */
    private static final String CDZL_BILL_CODE = "CDZL_BILL_CODE";
    /**
     * 外部检测合同
     */
    private static final String WBJC_BILL_CODE = "WBJC_BILL_CODE";
    /**
     * 外部设计合同
     */
    private static final String WBSJ_BILL_CODE = "WBSJ_BILL_CODE";
    /**
     * 外部产品认证合同
     */
    private static final String WBRZ_BILL_CODE = "WBRZ_BILL_CODE";
    /**
     * 劳务分包合同
     */
    private static final String LWFB_BILL_CODE = "LWFB_BILL_CODE";
    /**
     * 设备或材料采购合同
     */
    private static final String CLCG_BILL_CODE = "CLCG_BILL_CODE";
    /**
     * 设备租赁合同
     */
    private static final String SBZL_BILL_CODE = "SBZL_BILL_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractChangeService contractChangeService;

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        if (StringUtils.isEmpty(contractVo.getBillCode())) {
            // 合同编码生成
            entity.setBillCode(this.getContractBillCode(contractVo));
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getContractType, contractVo.getContractType());
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_type", new Parameter(QueryParam.EQ, contractVo.getContractType()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getContractType, contractVo.getContractType());
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("contract_type", new Parameter(QueryParam.EQ, contractVo.getContractType()));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        entity.setBaseMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseTaxMny(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeTaxMny(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        super.saveOrUpdate(entity, false);

        return CommonResponse.success(BeanMapper.map(entity, ContractVO.class));
    }

    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        String billCodeStr = "";
        if (PayoutTypeEnum.外协加工.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WXJG_BILL_CODE;
        } else if (PayoutTypeEnum.成品采购.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CPCG_BILL_CODE;
        } else if (PayoutTypeEnum.整体外包.getCode().equals(contractVo.getContractType())) {
            billCodeStr = ZTWB_BILL_CODE;
        } else if (PayoutTypeEnum.场地或设备租赁.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CDZL_BILL_CODE;
        } else if (PayoutTypeEnum.外部检测.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBJC_BILL_CODE;
        } else if (PayoutTypeEnum.外部设计.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBSJ_BILL_CODE;
        } else if (PayoutTypeEnum.外部产品认证.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WBRZ_BILL_CODE;
        } else if (PayoutTypeEnum.劳务分包.getCode().equals(contractVo.getContractType())) {
            billCodeStr = LWFB_BILL_CODE;
        } else if (PayoutTypeEnum.设备或材料采购.getCode().equals(contractVo.getContractType())) {
            billCodeStr = CLCG_BILL_CODE;
        } else if (PayoutTypeEnum.设备租赁.getCode().equals(contractVo.getContractType())) {
            billCodeStr = SBZL_BILL_CODE;
        }
        BillCodeParam billCodeParam = BillCodeParam
                .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            contractBillCode = billCode.getData();
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return contractBillCode;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = super.selectById(id);
        entity.setContractDetailList(null);
        ContractVO contractVo = BeanMapper.map(entity, ContractVO.class);
        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, id);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.终止项.getCode());
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setContractDetailList(BeanMapper.mapList(details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public List<ContractVO> queryContractList(Page page, QueryWrapper wrapper, Long projectId, Long orgId) {
        return baseMapper.queryContractList(page, wrapper, projectId, orgId);
    }

    @Override
    public List<SjCostReportVO> querySjCostList(Page page, QueryWrapper wrapper) {
        return baseMapper.querySjCostList(page, wrapper);
    }

    @Override
    public List<FinanceReportVO> queryFinanceList(Page page, QueryWrapper wrapper) {
        return baseMapper.queryFinancecList(page, wrapper);
    }

    @Override
    public BigDecimal queryFinanceSum(Long projectId) {
        /** 模糊搜索配置字段示例 */
        FinanceReportVO sumVO = baseMapper.queryFinancecSum(projectId);
        if (sumVO == null){
            return BigDecimal.ZERO;
        }
        if (sumVO.getReceiveMny() == null) sumVO.setReceiveMny(BigDecimal.ZERO);
        if (sumVO.getPaymentMny() == null) sumVO.setPaymentMny(BigDecimal.ZERO);
        return sumVO.getReceiveMny().subtract(sumVO.getPaymentMny());}

    @Override
    public List<SjCostReportVO> querySjDetailMny(Long projectId) {
        return baseMapper.querySjDetailMny(projectId);
    }

    @Override
    public List<SjCostReportVO> queryMaterialMny(Long projectId) {
        return baseMapper.queryMaterialMny(projectId);
    }

    @Override
    public List<SjCostReportVO> querySjCostMny(Long projectId) {
        return baseMapper.querySjCostMny(projectId);
    }

    @Override
    public List<TargetMaterialDetailVO> queryMaterialSum(Long projectId, Long wbsId) {
        return baseMapper.queryMaterialSum(projectId,wbsId);
    }

    @Override
    public List<TargetMaterialDetailVO> queryMaterialList(Page page, QueryWrapper wrapper,Long projectId, Long wbsId,Long materialId) {
        return baseMapper.queryMaterialList(page,wrapper,projectId,wbsId,materialId);
    }

    @Override
    public BigDecimal queryWorkTime(Long projectId, Long wbsId) {
        TargetMaterialDetailVO vo = baseMapper.querySjWorkTime(projectId, wbsId);
        if(null!=vo){
            return vo.getWorkTime();
        }
        return null;
    }

    @Override
    public List<TargetMaterialDetailVO> queryWorkTimeList(Page page, QueryWrapper wrapper,Long projectId, Long wbsId) {
        return baseMapper.querySjWorkTimeList(page,wrapper,projectId, wbsId);
    }

    @Override
    public List<ProjectRecordVO> queryProjectList() {
        return baseMapper.queryProjectList();
    }

    @Override
    public List<ContractVO> queryContractOrgList(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.queryContractOrgList(pages, queryWrapper);
    }

    @Override
    public List<SzReportVO> querySzList(QueryWrapper queryWrapper) {
        return baseMapper.querySzList(queryWrapper);
    }
}
