/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.payout.bean.BillData;
import com.ejianc.business.jlcost.payout.bean.ContractChangeEntity;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.enums.ChangeTypeEnum;
import com.ejianc.business.jlcost.payout.enums.PayoutTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.ContractChangeMapper;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;
import com.ejianc.business.jlcost.payout.service.IContractDetailService;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractChangeDetailVO;
import com.ejianc.business.jlcost.payout.vo.ContractChangeRecordVO;
import com.ejianc.business.jlcost.payout.vo.ContractChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WXJG_BILL_CODE = "WXJG_BILL_CODE";
    private static final String CPCG_BILL_CODE = "CPCG_BILL_CODE";
    private static final String ZTWB_BILL_CODE = "ZTWB_BILL_CODE";
    private static final String CDZL_BILL_CODE = "CDZL_BILL_CODE";
    private static final String WBJC_BILL_CODE = "WBJC_BILL_CODE";
    private static final String WBSJ_BILL_CODE = "WBSJ_BILL_CODE";
    private static final String WBRZ_BILL_CODE = "WBRZ_BILL_CODE";
    private static final String LWFB_BILL_CODE = "LWFB_BILL_CODE";
    private static final String CLCG_BILL_CODE = "CLCG_BILL_CODE";
    private static final String SBZL_BILL_CODE = "SBZL_BILL_CODE";
    private static final String WXJG_BILL_TYPE = "EJCBT202405000009";
    private static final String CPCG_BILL_TYPE = "EJCBT202405000010";
    private static final String ZTWB_BILL_TYPE = "EJCBT202405000013";
    private static final String CDZL_BILL_TYPE = "EJCBT202405000016";
    private static final String WBJC_BILL_TYPE = "EJCBT202405000019";
    private static final String WBSJ_BILL_TYPE = "EJCBT202405000022";
    private static final String WBRZ_BILL_TYPE = "EJCBT202405000025";
    private static final String LWFB_BILL_TYPE = "EJCBT202405000028";
    private static final String CLCG_BILL_TYPE = "EJCBT202405000032";
    private static final String SBZL_BILL_TYPE = "EJCBT202405000036";
    private static final String WXJG_CHANGE_BILL_TYPE = "EJCBT202405000007";
    private static final String CPCG_CHANGE_BILL_TYPE = "EJCBT202405000011";
    private static final String ZTWB_CHANGE_BILL_TYPE = "EJCBT202405000014";
    private static final String CDZL_CHANGE_BILL_TYPE = "EJCBT202405000017";
    private static final String WBJC_CHANGE_BILL_TYPE = "EJCBT202405000020";
    private static final String WBSJ_CHANGE_BILL_TYPE = "EJCBT202405000023";
    private static final String WBRZ_CHANGE_BILL_TYPE = "EJCBT202405000026";
    private static final String LWFB_CHANGE_BILL_TYPE = "EJCBT202405000029";
    private static final String CLCG_CHANGE_BILL_TYPE = "EJCBT202405000034";
    private static final String SBZL_CHANGE_BILL_TYPE = "EJCBT202405000037";
    private static final String WXJG_RECORD_BILL_TYPE = "EJCBT202405000008";
    private static final String CPCG_RECORD_BILL_TYPE = "EJCBT202405000012";
    private static final String ZTWB_RECORD_BILL_TYPE = "EJCBT202405000015";
    private static final String CDZL_RECORD_BILL_TYPE = "EJCBT202405000018";
    private static final String WBJC_RECORD_BILL_TYPE = "EJCBT202405000021";
    private static final String WBSJ_RECORD_BILL_TYPE = "EJCBT202405000024";
    private static final String WBRZ_RECORD_BILL_TYPE = "EJCBT202405000027";
    private static final String LWFB_RECORD_BILL_TYPE = "EJCBT202405000030";
    private static final String CLCG_RECORD_BILL_TYPE = "EJCBT202405000035";
    private static final String SBZL_RECORD_BILL_TYPE = "EJCBT202405000038";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractChangeService changeService;

    @Override
    public CommonResponse<ContractChangeVO> saveOrUpdate(ContractChangeVO contractChangeVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getContractType, (Object)contractChangeVo.getContractType());
        lambdachange.eq(ContractChangeEntity::getContractId, (Object)contractChangeVo.getContractId());
        if (contractChangeVo.getId() != null && contractChangeVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)contractChangeVo.getId());
        }
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        ContractEntity pcentity = (ContractEntity)((Object)this.contractService.selectById(contractChangeVo.getContractId()));
        if (contractChangeVo.getId() != null && contractChangeVo.getId() > 0L && this.changeService.getById(contractChangeVo.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVo.getBillCode());
            lambda.eq(ContractChangeEntity::getContractType, (Object)contractChangeVo.getContractType());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("contract_type", new Parameter("eq", (Object)contractChangeVo.getContractType()));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVo.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVo.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getContractType, (Object)contractChangeVo.getContractType());
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVo.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("contract_type", new Parameter("eq", (Object)contractChangeVo.getContractType()));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVo.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVo.getContractId());
            pcentity.setChangeVersion(contractChangeVo.getChangeVersion() + 1);
            contractChangeVo.setChangeVersion(Integer.valueOf(contractChangeVo.getChangeVersion() + 1));
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVo.getContractDetailList())) {
            contractChangeVo.getContractDetailList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVo.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVo)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVo.getContractClauseList())) {
            contractChangeVo.getContractClauseList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVo.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVo)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (ContractChangeEntity)((Object)BeanMapper.map((Object)contractChangeVo, ContractChangeEntity.class));
        entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        super.saveOrUpdate((Object)entity, false);
        pcentity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        pcentity.setChangeId(entity.getId());
        pcentity.setChangeContractName(entity.getContractName());
        this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        ContractChangeVO res = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        return CommonResponse.success((Object)res);
    }

    private boolean isInsertContractChange(ContractChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0L;
    }

    @Override
    public BillData getContractBillCodeAndType(ContractChangeVO contractVo) {
        String contractBillCode = "";
        String billTypeStr = "";
        String changeBillTypeStr = "";
        String recordBillTypeStr = "";
        if (PayoutTypeEnum.\u5916\u534f\u52a0\u5de5.getCode().equals(contractVo.getContractType())) {
            billTypeStr = WXJG_BILL_TYPE;
            changeBillTypeStr = WXJG_CHANGE_BILL_TYPE;
            recordBillTypeStr = WXJG_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u6210\u54c1\u91c7\u8d2d.getCode().equals(contractVo.getContractType())) {
            billTypeStr = CPCG_BILL_TYPE;
            changeBillTypeStr = CPCG_CHANGE_BILL_TYPE;
            recordBillTypeStr = CPCG_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u6574\u4f53\u5916\u5305.getCode().equals(contractVo.getContractType())) {
            billTypeStr = ZTWB_BILL_TYPE;
            changeBillTypeStr = ZTWB_CHANGE_BILL_TYPE;
            recordBillTypeStr = ZTWB_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u573a\u5730\u6216\u8bbe\u5907\u79df\u8d41.getCode().equals(contractVo.getContractType())) {
            billTypeStr = CDZL_BILL_TYPE;
            changeBillTypeStr = CDZL_CHANGE_BILL_TYPE;
            recordBillTypeStr = CDZL_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u68c0\u6d4b.getCode().equals(contractVo.getContractType())) {
            billTypeStr = WBJC_BILL_TYPE;
            changeBillTypeStr = WBJC_CHANGE_BILL_TYPE;
            recordBillTypeStr = WBJC_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u8bbe\u8ba1.getCode().equals(contractVo.getContractType())) {
            billTypeStr = WBSJ_BILL_TYPE;
            changeBillTypeStr = WBSJ_CHANGE_BILL_TYPE;
            recordBillTypeStr = WBSJ_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u5916\u90e8\u4ea7\u54c1\u8ba4\u8bc1.getCode().equals(contractVo.getContractType())) {
            billTypeStr = WBRZ_BILL_TYPE;
            changeBillTypeStr = WBRZ_CHANGE_BILL_TYPE;
            recordBillTypeStr = WBRZ_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u52b3\u52a1\u5206\u5305.getCode().equals(contractVo.getContractType())) {
            billTypeStr = LWFB_BILL_TYPE;
            changeBillTypeStr = LWFB_CHANGE_BILL_TYPE;
            recordBillTypeStr = LWFB_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u8bbe\u5907\u6216\u6750\u6599\u91c7\u8d2d.getCode().equals(contractVo.getContractType())) {
            billTypeStr = CLCG_BILL_TYPE;
            changeBillTypeStr = CLCG_CHANGE_BILL_TYPE;
            recordBillTypeStr = CLCG_RECORD_BILL_TYPE;
        } else if (PayoutTypeEnum.\u8bbe\u5907\u79df\u8d41.getCode().equals(contractVo.getContractType())) {
            billTypeStr = SBZL_BILL_TYPE;
            changeBillTypeStr = SBZL_CHANGE_BILL_TYPE;
            recordBillTypeStr = SBZL_RECORD_BILL_TYPE;
        }
        return new BillData(contractBillCode, billTypeStr, changeBillTypeStr, recordBillTypeStr);
    }

    @Override
    public ContractChangeVO queryDetail(Long id) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.changeService.selectById(id));
        ContractChangeVO vo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        return vo;
    }

    @Override
    public void deleteContractChange(List<ContractChangeVO> vos) {
        ContractChangeVO changeVo = vos.get(0);
        ContractChangeEntity entity = (ContractChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        ContractEntity pcentity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getContractId, (Object)pcentity.getId());
        lambdachange.in(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.changeService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            pcentity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        } else {
            pcentity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        pcentity.setChangingMny(BigDecimal.ZERO);
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ContractChangeVO queryDetails(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        ContractChangeVO changeVo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        changeVo.setContractId(changeVo.getId());
        changeVo.setId(Long.valueOf(IdWorker.getId()));
        changeVo.setBillState(null);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        changeVo.setBeforeContractName(entity.getContractName());
        changeVo.setBeforeChangeMny(entity.getContractMny());
        changeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        changeVo.setBeforeContractName(changeVo.getContractName());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)id);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            changeVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractChangeDetailVO.class));
            changeVo.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode().toString());
                vo.setContractId(changeVo.getContractId());
                vo.setBeforeChangeNum(vo.getNum());
                vo.setBeforeChangePrice(vo.getDetailTaxPrice());
                vo.setRowState("add");
            });
        } else {
            changeVo.setContractDetailList(new ArrayList());
        }
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getContractClauseList())) {
            changeVo.getContractClauseList().forEach(vo -> {
                vo.setContractId(changeVo.getContractId());
                vo.setRowState("add");
            });
        }
        BillData billData = this.getContractBillCodeAndType(changeVo);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), billData.getBillTypeStr(), "payoutContract", String.valueOf(changeVo.getId()), billData.getChangeBillTypeStr(), "contractChange");
        return changeVo;
    }

    @Override
    public ContractChangeRecordVO queryChangeRecord(Long id) {
        ContractChangeRecordVO vo = new ContractChangeRecordVO();
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal baseTaxMoney = entity.getBaseTaxMny() == null ? BigDecimal.ZERO : entity.getBaseTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if (vo.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney, 8, 5)));
        } else {
            vo.setSumScale(BigDecimal.ZERO);
        }
        if (entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getContractId, (Object)id);
            lambda.in(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(ContractChangeEntity::getChangeVersion);
            List entities = super.list((Wrapper)lambda);
            vo.setChangeRecord(BeanMapper.mapList((Iterable)entities, ContractChangeVO.class));
        }
        return vo;
    }
}

