package com.ejianc.business.jlcost.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlcost.finance.service.IBackService;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlcost.finance.bean.LoadApplyEntity;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;
import com.ejianc.business.jlcost.finance.vo.LoadApplyVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 资金管理-借款申请
 *
 * @author generator
 */
@Controller
@RequestMapping("loadApply")
public class LoadApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    // 备用金申请数据权限白名单角色配置
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-Smwe6l0001";

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String BILL_CODE = "LoadApply";//此处需要根据实际修改

    @Autowired
    private ILoadApplyService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBackService backService;

    @Autowired
    private IReimburseService reimburseService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoadApplyVO> saveOrUpdate(@RequestBody LoadApplyVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getBackedMny() == null) {
            saveOrUpdateVO.setBackedMny(BigDecimal.valueOf(0));
        }
        if(saveOrUpdateVO.getCumulativeMny()== null){
            saveOrUpdateVO.setCumulativeMny(BigDecimal.valueOf(0));
        }
        if(saveOrUpdateVO.getStatus()==null){
            saveOrUpdateVO.setStatus(1);
        }
        LoadApplyEntity entity = BeanMapper.map(saveOrUpdateVO, LoadApplyEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        LoadApplyVO vo = BeanMapper.map(entity, LoadApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LoadApplyVO> queryDetail(Long id) {
        LoadApplyEntity entity = service.selectById(id);
        LoadApplyVO vo = BeanMapper.map(entity, LoadApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LoadApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LoadApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编号、项目名称
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!canViewAll()) {
            param.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }
        IPage<LoadApplyEntity> page = service.queryPage(param, false);
        //设置金额
        List<LoadApplyEntity> records = page.getRecords();
        IPage<LoadApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LoadApplyVO> loadApplyVOS = BeanMapper.mapList(records, LoadApplyVO.class);
        pageData.setRecords(loadApplyVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编号、项目名称
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        if (!canViewAll()) {
            param.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }
        List<LoadApplyEntity> list = service.queryList(param);
        List<LoadApplyVO> applyVOList = BeanMapper.mapList(list, LoadApplyVO.class);


        for (LoadApplyVO vo : applyVOList) {



           if(vo.getStatus()==1){
               vo.setLoanStatus("申请中");
           }
           if(vo.getStatus()==2){
               vo.setLoanStatus("使用中");
           }
           if(vo.getStatus()==3){
               vo.setLoanStatus("已结束");
           }
           if(vo.getBillState()==0){
               vo.setBillStateName("自由态");
           }
           if(vo.getBillState()==1){
               vo.setBillStateName("已提交");
           }
            if(vo.getBillState()==2||vo.getBillState()==5){
                vo.setBillStateName("审批中");
            }
            if(vo.getBillState()==3){
                vo.setBillStateName("审批通过");
            }
            if(vo.getBillState()==4){
                vo.setBillStateName("审批驳回");
            }

        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", applyVOList);
        ExcelExport.getInstance().export("LoadApply-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refLoadApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> refLoadApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();

        Long employeeId = sessionManager.getUserContext().getEmployeeId();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //当前登录人过滤
        param.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, employeeId));
        List<Integer> list = new ArrayList<>();
        list.add(1);
        list.add(3);
        param.getParams().put("status",new Parameter(QueryParam.EQ,2));
        param.getParams().put("billState", new Parameter(QueryParam.IN, list));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LoadApplyEntity> page = service.queryPage(param, false);
        IPage<LoadApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LoadApplyVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @description: 根据当前用户角色判断是都可以查看全部备用金报销单
     * @return: java.lang.Boolean
     * @author songlx
     * @date: 2022/7/26
     */
    public Boolean canViewAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode()))
                            return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }


    @RequestMapping(value = "/reportQueryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> reportQueryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        Page<LoadApplyVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<LoadApplyVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("reportMonth", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.reportQueryList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());

        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 报表导出
     * @Return void
     */

    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {


        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Page<LoadApplyVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<LoadApplyVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("reportMonth", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.reportQueryList(page, wrapper);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LoadApplyReport-export.xlsx", beans, response);
    }

}
