/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.mapper.ReceiveMapper;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.ReceiveVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receiveService")
public class ReceiveServiceImpl
extends BaseServiceImpl<ReceiveMapper, ReceiveEntity>
implements IReceiveService {
    @Autowired
    private IInvoiceService invoiceService;

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ReceiveEntity::getContractId, (Object)contractId);
        queryWrapper.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(ReceiveEntity::getReceiveTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List receiveVOS = BeanMapper.mapList((Iterable)list, ReceiveVO.class);
            BigDecimal sumReceiveTaxMny = BigDecimal.ZERO;
            for (ReceiveEntity entity : list) {
                sumReceiveTaxMny = ComputeUtil.safeAdd((BigDecimal)sumReceiveTaxMny, (BigDecimal)entity.getReceiveMny());
            }
            jsonObject.put("sumReceiveTaxMny", (Object)sumReceiveTaxMny);
            jsonObject.put("detailList", (Object)receiveVOS);
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(InvoiceEntity::getContractId, (Object)contractId);
        queryWrapper2.in(InvoiceEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper2.orderByDesc(InvoiceEntity::getInvoiceDate);
        List list2 = this.invoiceService.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            BigDecimal sumInvoiceTaxMny = BigDecimal.ZERO;
            for (InvoiceEntity entity : list2) {
                sumInvoiceTaxMny = ComputeUtil.safeAdd((BigDecimal)sumInvoiceTaxMny, (BigDecimal)entity.getInvoiceTaxMny());
            }
            jsonObject.put("sumInvoiceTaxMny", (Object)sumInvoiceTaxMny);
        }
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> queryRecordByContIdList(List<Long> ids) {
        HashMap<Long, JSONObject> collectMap = new HashMap<Long, JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ReceiveEntity::getContractId, ids);
        queryWrapper.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(ReceiveEntity::getReceiveTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<Long, List<ReceiveEntity>> receiveDataMap = list.stream().collect(Collectors.groupingBy(ReceiveEntity::getContractId));
            for (Long contractId : receiveDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                List<ReceiveEntity> receiveEntityList = receiveDataMap.get(contractId);
                jsonObject.put("sumReceiveTaxMny", (Object)receiveEntityList.stream().filter(e -> null != e.getReceiveMny()).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                jsonObject.put("receiveDetailList", receiveEntityList);
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}

