/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlcost.cost.bean.TargetChangeDetailEntity;
import com.ejianc.business.jlcost.cost.bean.TargetChangeEntity;
import com.ejianc.business.jlcost.cost.bean.TargetEntity;
import com.ejianc.business.jlcost.cost.bean.TargetRecordEntity;
import com.ejianc.business.jlcost.cost.mapper.TargetChangeMapper;
import com.ejianc.business.jlcost.cost.mapper.TargetMapper;
import com.ejianc.business.jlcost.cost.service.ITargetChangeService;
import com.ejianc.business.jlcost.cost.service.ITargetRecordService;
import com.ejianc.business.jlcost.cost.service.ITargetService;
import com.ejianc.business.jlcost.cost.vo.TargetChangeDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetChangeVO;
import com.ejianc.business.jlcost.cost.vo.TargetRecordDetailVO;
import com.ejianc.business.jlcost.cost.vo.TargetRecordVO;
import com.ejianc.business.jlcost.cost.vo.TargetVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetChangeService")
public class TargetChangeServiceImpl
extends BaseServiceImpl<TargetChangeMapper, TargetChangeEntity>
implements ITargetChangeService {
    @Autowired
    private ITargetService targetService;
    @Autowired
    private ITargetRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String XSHT_MNY_PARAM_CODE = "P-kLiO450011";
    @Autowired
    private TargetMapper targetMapper;

    @Override
    public TargetChangeVO queryDetailChange(Long targetId) {
        TargetEntity entity = (TargetEntity)((Object)this.targetService.selectById(targetId));
        TargetChangeVO changeVo = (TargetChangeVO)BeanMapper.map((Object)((Object)entity), TargetChangeVO.class);
        changeVo.setTargetId(targetId);
        changeVo.setId(Long.valueOf(IdWorker.getId()));
        changeVo.setBeforeCostMny(changeVo.getCostMny());
        changeVo.setBillState(null);
        changeVo.setBillCode(entity.getBillCode() + "-" + (entity.getChangeVersion() + 1));
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        ArrayList<TargetChangeDetailVO> detailVOList = new ArrayList<TargetChangeDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getDetailList())) {
            for (TargetChangeDetailVO detailVO : changeVo.getDetailList()) {
                detailVO.setRowState("add");
                detailVO.setIfChange(Integer.valueOf(0));
                detailVO.setBeforeMny(detailVO.getMny());
                detailVO.setBeforeNum(detailVO.getNum());
                detailVO.setBeforePrice(detailVO.getPrice());
                detailVO.setSourceDetailId(detailVO.getId());
                detailVO.setSourceTargetId(targetId);
                detailVO.setTid(detailVO.getId());
                detailVO.setTpid(detailVO.getParentId() != null ? detailVO.getParentId().toString() : null);
                detailVOList.add(detailVO);
            }
            changeVo.setDetailList(TreeNodeBUtil.buildTree(detailVOList));
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(targetId), "EJCBT202406000004", "attachMgr", String.valueOf(changeVo.getId()), "EJCBT202406000005", "attachMgr");
        return changeVo;
    }

    @Override
    public CommonResponse<TargetChangeVO> insertOrUpdate(TargetChangeVO saveOrUpdateVO) {
        TargetChangeEntity entity = (TargetChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TargetChangeEntity.class));
        List<TargetChangeDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TargetChangeDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null || "add".equals(detail.getRowState())) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (TargetChangeDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        TargetEntity targetEntity = (TargetEntity)((Object)this.targetService.selectById(entity.getTargetId()));
        targetEntity.setChangeStatus(2);
        targetEntity.setBeforeChangeId(targetEntity.getChangeId());
        targetEntity.setChangeId(entity.getId());
        targetEntity.setChangeCode(entity.getBillCode());
        targetEntity.setChangeVersion(targetEntity.getChangeVersion() + 1);
        this.targetService.saveOrUpdate((Object)targetEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    @Override
    public TargetChangeVO queryDetail(Long id) {
        TargetChangeEntity entity = (TargetChangeEntity)((Object)super.selectById((Serializable)id));
        TargetChangeVO vo = (TargetChangeVO)BeanMapper.map((Object)((Object)entity), TargetChangeVO.class);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TargetChangeDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<TargetRecordVO> queryRecord(Long id) {
        List detailList;
        List targetRecordEntityList = this.recordService.list((Wrapper)new QueryWrapper().eq((Object)"change_id", (Object)id));
        TargetRecordVO recordVO = new TargetRecordVO();
        if (!targetRecordEntityList.isEmpty() && CollectionUtils.isNotEmpty((Collection)(detailList = (recordVO = (TargetRecordVO)BeanMapper.map((Object)this.recordService.selectById(((TargetRecordEntity)((Object)targetRecordEntityList.get(0))).getId()), TargetRecordVO.class)).getDetailList()))) {
            for (TargetRecordDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            recordVO.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)recordVO);
    }

    @Override
    public ParamsCheckVO checkParams(TargetChangeVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(TargetChangeVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal mny = vo.getCostMny();
        TargetVO targetVO = this.targetMapper.queryContractTaxMnyByProjectId(vo.getProjectId());
        if (null == targetVO || null == targetVO.getContractTaxMny()) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = targetVO.getContractTaxMny();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(XSHT_MNY_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u9500\u552e\u5408\u540c\u91d1\u989d\u3011\u7ba1\u63a7\u3010\u76ee\u6807\u6210\u672c\u91d1\u989d\u3011\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\u8d85\u989d\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\u8d85\u9500\u552e\u5408\u540c\u603b\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        String mnyStr = mny.setScale(2, 4).toString();
                        String contractTaxMnyStr = contractTaxMny.setScale(2, 4).toString();
                        String text = "\u8d85\u51fa\u91d1\u989d\uff1a" + mnyStr + "-" + contractTaxMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)comMny).setScale(2, 4) + "\u5143";
                        String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                        stringBuffer.append("\u76ee\u6807\u6210\u672c\u603b\u91d1\u989d\uff1a").append(mnyStr).append("\u5143\uff0c\u9500\u552e\u5408\u540c\u603b\u91d1\u989d\uff1a").append(contractTaxMnyStr).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(roleValue).append("%\uff0c").append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

