/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleBillCodeEnum;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList())) {
            BigDecimal settleMny = BigDecimal.ZERO;
            BigDecimal settleTaxMny = BigDecimal.ZERO;
            BigDecimal settleTax = BigDecimal.ZERO;
            for (SettleDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                settleMny = ComputeUtil.safeAdd((BigDecimal)settleMny, (BigDecimal)detailVO.getMny());
                settleTaxMny = ComputeUtil.safeAdd((BigDecimal)settleTaxMny, (BigDecimal)detailVO.getTaxMny());
                settleTax = ComputeUtil.safeAdd((BigDecimal)settleTax, (BigDecimal)detailVO.getTax());
            }
            BigDecimal sumSettleAllMny = ComputeUtil.safeAdd((BigDecimal)settleMny, (BigDecimal)saveOrUpdateVO.getSumSettleMny());
            BigDecimal sumSettleAllTaxMny = ComputeUtil.safeAdd((BigDecimal)settleTaxMny, (BigDecimal)saveOrUpdateVO.getSumSettleTaxMny());
            saveOrUpdateVO.setSettleMny(settleMny);
            saveOrUpdateVO.setSettleTaxMny(settleTaxMny);
            saveOrUpdateVO.setSettleTax(settleTax);
            saveOrUpdateVO.setSumSettleAllMny(sumSettleAllMny);
            saveOrUpdateVO.setSumSettleAllTaxMny(sumSettleAllTaxMny);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(SettleEntity::getContractId, (Object)saveOrUpdateVO.getContractId());
        queryWrapper.eq(SettleEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.getOne((Wrapper)queryWrapper, false));
        if (null != settleEntity) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u8be5\u9879\u76ee\u4e0a\u5b58\u5728\u672a\u5b8c\u6210\u7684\u7ed3\u7b97\u5355\u3010" + settleEntity.getBillCode() + "\u3011,\u4e0d\u53ef\u518d\u6b21\u65b0\u589e\u7ed3\u7b97\u5355\uff01");
        }
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)SettleBillCodeEnum.getEnumByType(saveOrUpdateVO.getSettleBillType()).getBillCode(), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO settleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        this.buildParam(param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryReport(@RequestBody QueryParam param) {
        this.buildParam(param);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySettleList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> querySettleList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        Long contractId = Long.valueOf(((Parameter)param.getParams().get("contractId")).getValue().toString());
        param.getParams().remove("contractId");
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
            param.getParams().remove("projectId");
        }
        if ("5".equals(InvocationInfoProxy.getOrgType()) || null != projectId) {
            List<Object> resList = new ArrayList();
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            resList = null != projectId ? this.service.querySettleList(page, wrapper, contractId, projectId, null) : this.service.querySettleList(page, wrapper, contractId, null, orgId);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(resList);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List<Object> resList = new ArrayList();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        resList = this.service.querySettleOrgList(page, wrapper, contractId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void buildParam(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SettleVO>> commonResponse = this.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = ((IPage)commonResponse.getData()).getRecords();
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", records);
        ExcelExport.getInstance().export("Settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySumMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> querySumMny(@RequestParam Long contractId, @RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u91d1\u989d\u6210\u529f\uff01", (Object)this.service.querySumMny(contractId, projectId));
    }

    @RequestMapping(value={"/contToSettle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> contToSettle(@RequestParam Long contractId) {
        return CommonResponse.success((String)"\u5408\u540c\u751f\u6210\u7ed3\u7b97\u6210\u529f\uff01", (Object)this.service.contToSettle(contractId));
    }

    @RequestMapping(value={"/queryRecordByContId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryRecordByContId(@RequestParam Long contractId) {
        return CommonResponse.success((String)"\u5408\u540c\u67e5\u8be2\u7ed3\u7b97\u6210\u529f\uff01", (Object)this.service.queryRecordByContId(contractId));
    }

    @RequestMapping(value={"/checkWbsjParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbsjParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkWbsjParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/checkLwfbSbclSbzlParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkLwfbSbclSbzlParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkLwfbSbclSbzlParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"/checkWbjcParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbjcParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkWbjcParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"/checkWbcpParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWbcpParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkWbcpParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"/checkWxjgParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkWxjgParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkWxjgParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @PostMapping(value={"/checkCpcgParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkCpcgParams(@RequestBody SettleVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkCpcgParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

