package com.ejianc.business.jlcost.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 资金管理-收款单
 *
 * @author generator
 */
@TableName("ejc_finance_receive")
public class ReceiveEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "project_id")
    private Long projectId; // 项目id
    @TableField(value = "project_code")
    private String projectCode; // 项目code
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "contract_id")
    private Long contractId; // 销售合同ID
    @TableField(value = "contract_code")
    private String contractCode; // 销售合同code
    @TableField(value = "contract_name")
    private String contractName; // 销售合同名称
    @TableField(value = "customer_id")
    private Long customerId; // 合同甲方Id
    @TableField(value = "customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 合同乙方Id
    @TableField(value = "supplier_name")
    private String supplierName; // 合同乙方名称
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_code")
    private String orgCode; // 组织编码
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "contract_sale_id")
    private Long contractSaleId; // 销售人员Id
    @TableField(value = "contract_sale_name")
    private String contractSaleName; // 销售人员名称
    @TableField(value = "pay_type")
    private Integer payType; // 收款类型：1-预付款 2-过程结算款 3-质保金 4-其他
    @TableField(value = "receive_way_id")
    private String receiveWayId; // 收款方式
    @TableField(value = "receive_way_name")
    private String receiveWayName; // 收款方式名称
    @TableField(value = "receive_time")
    private Date receiveTime; // 收款日期
    @TableField(value = "receive_mny")
    private BigDecimal receiveMny; // 本期收款金额
    @TableField(value = "sum_receive_mny")
    private BigDecimal sumReceiveMny; // 累计收款金额
    @TableField(value = "sum_all_receive_mny")
    private BigDecimal sumAllReceiveMny; // 含本期累计收款金额
    @TableField(value = "sum_invoicing_mny")
    private BigDecimal sumInvoicingMny; // 累计开票金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value = "sum_collect_scale")
    private BigDecimal sumCollectScale; // 累计收款比例
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }


    public String getReceiveWayId() {
        return receiveWayId;
    }

    public void setReceiveWayId(String receiveWayId) {
        this.receiveWayId = receiveWayId;
    }

    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }

    public BigDecimal getSumAllReceiveMny() {
        return sumAllReceiveMny;
    }

    public void setSumAllReceiveMny(BigDecimal sumAllReceiveMny) {
        this.sumAllReceiveMny = sumAllReceiveMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumCollectScale() {
        return sumCollectScale;
    }

    public void setSumCollectScale(BigDecimal sumCollectScale) {
        this.sumCollectScale = sumCollectScale;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getContractSaleId() {
        return contractSaleId;
    }

    public void setContractSaleId(Long contractSaleId) {
        this.contractSaleId = contractSaleId;
    }

    public String getContractSaleName() {
        return contractSaleName;
    }

    public void setContractSaleName(String contractSaleName) {
        this.contractSaleName = contractSaleName;
    }
}
