package com.ejianc.business.jltest.crmtest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.crmtest.vo.TeamEmployeeVO;
import com.ejianc.business.jltest.crmtest.vo.TeamActiveVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 团队
 * 
 * @author generator
 * 
 */
public class TeamVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态（审批必须字段）
    private String teamName; // 团队名称
    private BigDecimal teamMny; // 团队资金
    private Long ceshiId; // 测试ID
    private String ceshiName; // 测试名称
    private String ceshiCode; // 测试编码
    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Integer teamType; // 团队类型 1-A类型 2-B类型
    private Long strategyWays; // 合作方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date teamDate; // 成立日期
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date teamTime; // 成立时间
    private String memo; // 备注
    
    private List<TeamEmployeeVO> teamEmployeeList = new ArrayList<>(); // 团队成员
    private List<TeamActiveVO> teamActiveList = new ArrayList<>(); // 团队活动

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public BigDecimal getTeamMny() {
        return teamMny;
    }

    public void setTeamMny(BigDecimal teamMny) {
        this.teamMny = teamMny;
    }
    public Long getCeshiId() {
        return ceshiId;
    }

    public void setCeshiId(Long ceshiId) {
        this.ceshiId = ceshiId;
    }
    public String getCeshiName() {
        return ceshiName;
    }

    public void setCeshiName(String ceshiName) {
        this.ceshiName = ceshiName;
    }
    public String getCeshiCode() {
        return ceshiCode;
    }

    public void setCeshiCode(String ceshiCode) {
        this.ceshiCode = ceshiCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Integer getTeamType() {
        return teamType;
    }

    public void setTeamType(Integer teamType) {
        this.teamType = teamType;
    }
    public Long getStrategyWays() {
        return strategyWays;
    }
    @ReferSerialTransfer(referCode = "strategy-ways")
    public void setStrategyWays(Long strategyWays) {
        this.strategyWays = strategyWays;
    }
    @ReferDeserialTransfer
    public Date getTeamDate() {
        return teamDate;
    }

    public void setTeamDate(Date teamDate) {
        this.teamDate = teamDate;
    }
    public Date getTeamTime() {
        return teamTime;
    }

    public void setTeamTime(Date teamTime) {
        this.teamTime = teamTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<TeamEmployeeVO> getTeamEmployeeList() {
        return teamEmployeeList;
     }

     public void setTeamEmployeeList(List<TeamEmployeeVO> teamEmployeeList) {
        this.teamEmployeeList = teamEmployeeList;
     }
     public List<TeamActiveVO> getTeamActiveList() {
        return teamActiveList;
     }

     public void setTeamActiveList(List<TeamActiveVO> teamActiveList) {
        this.teamActiveList = teamActiveList;
     }
}
